/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class WebClientUrl {
    private String authenticationMethods;
    private String url;

    private WebClientUrl() {
    }

    protected WebClientUrl(String authenticationMethods, String url) {
        this.authenticationMethods = authenticationMethods;
        this.url = url;
    }

    protected static WebClientUrl loadFromXml(EwsXmlReader reader) throws Exception {
        WebClientUrl webClientUrl = new WebClientUrl();
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("AuthenticationMethods")) {
                webClientUrl.setAuthenticationMethods(reader.readElementValue(String.class));
                continue;
            }
            if (!reader.getLocalName().equals("Url")) continue;
            webClientUrl.setUrl(reader.readElementValue(String.class));
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, "WebClientUrl"));
        return webClientUrl;
    }

    public String getAuthenticationMethods() {
        return this.authenticationMethods;
    }

    protected void setAuthenticationMethods(String value) {
        this.authenticationMethods = value;
    }

    public String getUrl() {
        return this.url;
    }

    protected void setUrl(String value) {
        this.url = value;
    }
}

