/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.httpcore.middlewareoption;

import com.microsoft.graph.httpcore.middlewareoption.IMiddlewareControl;
import com.microsoft.graph.httpcore.middlewareoption.IShouldRedirect;
import okhttp3.Response;

public class RedirectOptions
implements IMiddlewareControl {
    private int maxRedirects;
    public static final int DEFAULT_MAX_REDIRECTS = 5;
    public static final int MAX_REDIRECTS = 20;
    private IShouldRedirect shouldRedirect;
    public static final IShouldRedirect DEFAULT_SHOULD_REDIRECT = new IShouldRedirect(){

        @Override
        public boolean shouldRedirect(Response response) {
            return true;
        }
    };

    public RedirectOptions() {
        this(5, DEFAULT_SHOULD_REDIRECT);
    }

    public RedirectOptions(int maxRedirects, IShouldRedirect shouldRedirect) {
        if (maxRedirects < 0) {
            throw new IllegalArgumentException("Max redirects cannot be negative");
        }
        if (maxRedirects > 20) {
            throw new IllegalArgumentException("Max redirect cannot exceed 20");
        }
        this.maxRedirects = maxRedirects;
        this.shouldRedirect = shouldRedirect != null ? shouldRedirect : DEFAULT_SHOULD_REDIRECT;
    }

    public int maxRedirects() {
        return this.maxRedirects;
    }

    public IShouldRedirect shouldRedirect() {
        return this.shouldRedirect;
    }
}

