/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TimeOfDay {
    private final int mHour;
    private final int mMinute;
    private final int mSecond;

    @Nullable
    public static TimeOfDay parse(@Nonnull String timeStr) throws ParseException {
        Objects.requireNonNull(timeStr, "parameter timeStr cannot be null");
        String[] timeInfo = timeStr.split(":");
        int expectedLength = 3;
        if (timeInfo.length != 3) {
            throw new ParseException("Expected time string format 'HH:mm:ss' but found: " + timeStr, 0);
        }
        boolean indHour = false;
        boolean indMinute = true;
        int indSecond = 2;
        int hour = Integer.parseInt(timeInfo[0]);
        int minute = Integer.parseInt(timeInfo[1]);
        int second = new BigDecimal(timeInfo[2]).intValue();
        return new TimeOfDay(hour, minute, second);
    }

    public TimeOfDay(int hour, int minute, int second) {
        this.mHour = hour;
        this.mMinute = minute;
        this.mSecond = second;
    }

    public int getHour() {
        return this.mHour;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public int getSecond() {
        return this.mSecond;
    }

    @Nonnull
    public String toString() {
        return String.format(Locale.ROOT, "%02d:%02d:%02d", this.mHour, this.mMinute, this.mSecond);
    }
}

