/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.http.ICollectionResponse;
import com.microsoft.graph.serializer.AdditionalDataManager;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class BaseCollectionResponse<T>
implements ICollectionResponse<T> {
    @SerializedName(value="value")
    @Expose
    @Nullable
    public List<T> value;
    @SerializedName(value="@odata.nextLink")
    @Expose(serialize=false)
    @Nullable
    public String nextLink;
    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);
    private static final String VALUE_JSON_KEY = "value";

    @Override
    @Nullable
    public List<T> values() {
        return this.value;
    }

    @Override
    @Nullable
    public String nextLink() {
        return this.nextLink;
    }

    @Override
    @Nonnull
    @SuppressFBWarnings
    public final AdditionalDataManager additionalDataManager() {
        return this.additionalDataManager;
    }

    @Override
    public void setRawObject(@Nonnull ISerializer serializer, @Nonnull JsonObject json) {
        Objects.requireNonNull(serializer, "parameter serializer cannot be null");
        Objects.requireNonNull(json, "parameter json cannot be null");
        if (json.has(VALUE_JSON_KEY) && this.value != null && !this.value.isEmpty()) {
            JsonArray array = json.getAsJsonArray(VALUE_JSON_KEY);
            for (int i = 0; i < array.size() && i < this.value.size(); ++i) {
                T targetObject = this.value.get(i);
                if (!(targetObject instanceof IJsonBackedObject) || !array.get(i).isJsonObject()) continue;
                ((IJsonBackedObject)targetObject).setRawObject(serializer, array.get(i).getAsJsonObject());
            }
        }
    }
}

