/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.tasks;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.tasks.LargeFileUploadResponse;
import com.microsoft.graph.tasks.LargeFileUploadResponseHandler;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class LargeFileUploadRequest<UploadType> {
    private static final String CONTENT_RANGE_HEADER_NAME = "Content-Range";
    private static final String CONTENT_RANGE_FORMAT = "bytes %1$d-%2$d/%3$d";
    private final byte[] data;
    private final BaseRequest<LargeFileUploadResponse<UploadType>> baseRequest;

    protected LargeFileUploadRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> options, @Nonnull byte[] chunk, int chunkSize, long beginIndex, long totalLength) {
        Objects.requireNonNull(requestUrl, "parameter requestUrl cannot be null");
        Objects.requireNonNull(client, "parameter client cannot be null");
        Objects.requireNonNull(chunk, "parameter chunk cannot be null");
        this.data = new byte[chunkSize];
        System.arraycopy(chunk, 0, this.data, 0, chunkSize);
        this.baseRequest = new BaseRequest<LargeFileUploadResponse<UploadType>>(requestUrl, client, options, new LargeFileUploadResponse<Object>(null).getClass()){};
        this.baseRequest.setHttpMethod(HttpMethod.PUT);
        this.baseRequest.addHeader(CONTENT_RANGE_HEADER_NAME, String.format(Locale.ROOT, CONTENT_RANGE_FORMAT, beginIndex, beginIndex + (long)chunkSize - 1L, totalLength));
    }

    @Nonnull
    public LargeFileUploadResponse<UploadType> upload(@Nonnull LargeFileUploadResponseHandler<UploadType> responseHandler) {
        Objects.requireNonNull(responseHandler, "parameter responseHandler cannot be null");
        LargeFileUploadResponse result = null;
        try {
            result = this.baseRequest.getClient().getHttpProvider().send(this.baseRequest, LargeFileUploadResponse.class, this.data, responseHandler);
        }
        catch (ClientException e) {
            throw new ClientException("Request failed with error, retry if necessary.", e);
        }
        if (result != null && (result.chunkCompleted() || result.uploadCompleted())) {
            return result;
        }
        return new LargeFileUploadResponse(new ClientException("Upload session failed.", result == null ? null : result.getError()));
    }
}

