/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.callrecords.requests.extensions;

import com.microsoft.graph.callrecords.models.extensions.CallRecord;
import com.microsoft.graph.callrecords.requests.extensions.CallRecordCollectionPage;
import com.microsoft.graph.callrecords.requests.extensions.CallRecordCollectionRequestBuilder;
import com.microsoft.graph.callrecords.requests.extensions.CallRecordCollectionResponse;
import com.microsoft.graph.callrecords.requests.extensions.CallRecordRequestBuilder;
import com.microsoft.graph.callrecords.requests.extensions.ICallRecordCollectionPage;
import com.microsoft.graph.callrecords.requests.extensions.ICallRecordCollectionRequest;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import java.util.List;

public class CallRecordCollectionRequest
extends BaseCollectionRequest<CallRecordCollectionResponse, ICallRecordCollectionPage>
implements ICallRecordCollectionRequest {
    public CallRecordCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CallRecordCollectionResponse.class, ICallRecordCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ICallRecordCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(CallRecordCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ICallRecordCollectionPage get() throws ClientException {
        CallRecordCollectionResponse response = (CallRecordCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(CallRecord newCallRecord, ICallback<? super CallRecord> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new CallRecordRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCallRecord, callback);
    }

    @Override
    public CallRecord post(CallRecord newCallRecord) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CallRecordRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCallRecord);
    }

    @Override
    public ICallRecordCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ICallRecordCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ICallRecordCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ICallRecordCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICallRecordCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ICallRecordCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ICallRecordCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ICallRecordCollectionPage buildFromResponse(CallRecordCollectionResponse response) {
        CallRecordCollectionRequestBuilder builder = response.nextLink != null ? new CallRecordCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        CallRecordCollectionPage page = new CallRecordCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

