/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DetectedApp;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DetectedAppCollectionPage;
import com.microsoft.graph.requests.extensions.DetectedAppCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DetectedAppCollectionResponse;
import com.microsoft.graph.requests.extensions.DetectedAppRequestBuilder;
import com.microsoft.graph.requests.extensions.IDetectedAppCollectionPage;
import com.microsoft.graph.requests.extensions.IDetectedAppCollectionRequest;
import java.util.List;

public class DetectedAppCollectionRequest
extends BaseCollectionRequest<DetectedAppCollectionResponse, IDetectedAppCollectionPage>
implements IDetectedAppCollectionRequest {
    public DetectedAppCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DetectedAppCollectionResponse.class, IDetectedAppCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IDetectedAppCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DetectedAppCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDetectedAppCollectionPage get() throws ClientException {
        DetectedAppCollectionResponse response = (DetectedAppCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DetectedApp newDetectedApp, ICallback<? super DetectedApp> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DetectedAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDetectedApp, callback);
    }

    @Override
    public DetectedApp post(DetectedApp newDetectedApp) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DetectedAppRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDetectedApp);
    }

    @Override
    public IDetectedAppCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDetectedAppCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDetectedAppCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IDetectedAppCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDetectedAppCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDetectedAppCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDetectedAppCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDetectedAppCollectionPage buildFromResponse(DetectedAppCollectionResponse response) {
        DetectedAppCollectionRequestBuilder builder = response.nextLink != null ? new DetectedAppCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DetectedAppCollectionPage page = new DetectedAppCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

