/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DriveItemInviteBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DriveItemInviteCollectionPage;
import com.microsoft.graph.requests.extensions.DriveItemInviteCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemInviteCollectionResponse;
import com.microsoft.graph.requests.extensions.IDriveItemInviteCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveItemInviteCollectionRequest;
import java.util.List;

public class DriveItemInviteCollectionRequest
extends BaseCollectionRequest<DriveItemInviteCollectionResponse, IDriveItemInviteCollectionPage>
implements IDriveItemInviteCollectionRequest {
    protected final DriveItemInviteBody body = new DriveItemInviteBody();

    public DriveItemInviteCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveItemInviteCollectionResponse.class, IDriveItemInviteCollectionPage.class);
    }

    @Override
    public void post(final ICallback<? super IDriveItemInviteCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DriveItemInviteCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveItemInviteCollectionPage post() throws ClientException {
        DriveItemInviteCollectionResponse response = (DriveItemInviteCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public IDriveItemInviteCollectionPage buildFromResponse(DriveItemInviteCollectionResponse response) {
        DriveItemInviteCollectionRequestBuilder builder = response.nextLink != null ? new DriveItemInviteCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null, null, null, null, null, null, null) : null;
        DriveItemInviteCollectionPage page = new DriveItemInviteCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IDriveItemInviteCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveItemInviteCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDriveItemInviteCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IDriveItemInviteCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IDriveItemInviteCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

