/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.NamedLocation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.INamedLocationRequest;
import java.util.List;

public class NamedLocationRequest
extends BaseRequest
implements INamedLocationRequest {
    public NamedLocationRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends NamedLocation> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public NamedLocationRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, NamedLocation.class);
    }

    @Override
    public void get(ICallback<? super NamedLocation> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public NamedLocation get() throws ClientException {
        return (NamedLocation)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super NamedLocation> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(NamedLocation sourceNamedLocation, ICallback<? super NamedLocation> callback) {
        this.send(HttpMethod.PATCH, callback, sourceNamedLocation);
    }

    @Override
    public NamedLocation patch(NamedLocation sourceNamedLocation) throws ClientException {
        return (NamedLocation)this.send(HttpMethod.PATCH, sourceNamedLocation);
    }

    @Override
    public void post(NamedLocation newNamedLocation, ICallback<? super NamedLocation> callback) {
        this.send(HttpMethod.POST, callback, newNamedLocation);
    }

    @Override
    public NamedLocation post(NamedLocation newNamedLocation) throws ClientException {
        return (NamedLocation)this.send(HttpMethod.POST, newNamedLocation);
    }

    @Override
    public void put(NamedLocation newNamedLocation, ICallback<? super NamedLocation> callback) {
        this.send(HttpMethod.PUT, callback, newNamedLocation);
    }

    @Override
    public NamedLocation put(NamedLocation newNamedLocation) throws ClientException {
        return (NamedLocation)this.send(HttpMethod.PUT, newNamedLocation);
    }

    @Override
    public INamedLocationRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public INamedLocationRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

