/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.TodoTaskList;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITodoTaskListRequest;
import java.util.List;

public class TodoTaskListRequest
extends BaseRequest
implements ITodoTaskListRequest {
    public TodoTaskListRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TodoTaskList.class);
    }

    @Override
    public void get(ICallback<? super TodoTaskList> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public TodoTaskList get() throws ClientException {
        return (TodoTaskList)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super TodoTaskList> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(TodoTaskList sourceTodoTaskList, ICallback<? super TodoTaskList> callback) {
        this.send(HttpMethod.PATCH, callback, sourceTodoTaskList);
    }

    @Override
    public TodoTaskList patch(TodoTaskList sourceTodoTaskList) throws ClientException {
        return (TodoTaskList)this.send(HttpMethod.PATCH, sourceTodoTaskList);
    }

    @Override
    public void post(TodoTaskList newTodoTaskList, ICallback<? super TodoTaskList> callback) {
        this.send(HttpMethod.POST, callback, newTodoTaskList);
    }

    @Override
    public TodoTaskList post(TodoTaskList newTodoTaskList) throws ClientException {
        return (TodoTaskList)this.send(HttpMethod.POST, newTodoTaskList);
    }

    @Override
    public void put(TodoTaskList newTodoTaskList, ICallback<? super TodoTaskList> callback) {
        this.send(HttpMethod.PUT, callback, newTodoTaskList);
    }

    @Override
    public TodoTaskList put(TodoTaskList newTodoTaskList) throws ClientException {
        return (TodoTaskList)this.send(HttpMethod.PUT, newTodoTaskList);
    }

    @Override
    public ITodoTaskListRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITodoTaskListRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

