/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapterFactory;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.FallbackTypeAdapterFactory;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.Iterator;

public class EnumSetSerializer {
    private final Gson gson;

    public EnumSetSerializer(ILogger logger) {
        this.gson = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new FallbackTypeAdapterFactory(logger)).create();
    }

    public EnumSet<?> deserialize(Type type, String jsonStrToDeserialize) {
        String arrayString = "[" + jsonStrToDeserialize + "]";
        return jsonStrToDeserialize == null ? null : (EnumSet)this.gson.fromJson(arrayString, type);
    }

    public JsonPrimitive serialize(EnumSet<?> src) {
        StringBuilder serializedStringBuilder = new StringBuilder();
        Iterator i = src.iterator();
        while (i.hasNext()) {
            String jsonValue = this.gson.toJson(i.next());
            serializedStringBuilder.append(jsonValue.substring(1, jsonValue.length() - 1));
            if (!i.hasNext()) continue;
            serializedStringBuilder.append(",");
        }
        return new JsonPrimitive(serializedStringBuilder.toString());
    }
}

