/*
 * Decompiled with CFR 0.152.
 */
package com.mybatisflex.spring.batch;

import com.mybatisflex.core.BaseMapper;
import com.mybatisflex.core.paginate.Page;
import com.mybatisflex.core.query.QueryWrapper;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mybatis.spring.batch.MyBatisPagingItemReader;
import org.springframework.batch.item.database.AbstractPagingItemReader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class MybatisFlexPagingItemReader<T>
extends AbstractPagingItemReader<T> {
    private BaseMapper<T> mapper;
    private QueryWrapper queryWrapper;

    public MybatisFlexPagingItemReader() {
        this.setName(ClassUtils.getShortName(MyBatisPagingItemReader.class));
    }

    public void setMapper(BaseMapper<T> mapper) {
        this.mapper = mapper;
    }

    public void setQueryWrapper(QueryWrapper queryWrapper) {
        this.queryWrapper = queryWrapper;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull(this.mapper, (String)"mapper is required.");
        Assert.notNull((Object)this.queryWrapper, (String)"querywrapper is required.");
    }

    protected void doReadPage() {
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList();
        } else {
            this.results.clear();
        }
        Page paginate = this.mapper.paginate((Number)(this.getPage() + 1), (Number)this.getPageSize(), this.queryWrapper);
        this.results.addAll(paginate.getRecords());
    }

    protected void doJumpToPage(int itemIndex) {
        if (this.results == null) {
            this.results = new CopyOnWriteArrayList();
        } else {
            this.results.clear();
        }
        Page paginate = this.mapper.paginate((Number)(itemIndex + 1), (Number)this.getPageSize(), this.queryWrapper);
        this.results.addAll(paginate.getRecords());
    }
}

