/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.config.redisson;

import com.naah69.core.config.redisson.RedissonConnectionConfiguration;
import com.naah69.core.config.redisson.RedissonConnectionFactory;
import com.naah69.core.config.redisson.RedissonProperties;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={Redisson.class, RedisOperations.class})
@ConditionalOnProperty(prefix="spring.redis.redisson", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={RedissonProperties.class, RedisProperties.class})
public class RedissonAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedissonAutoConfiguration.class);
    @Autowired
    private RedissonProperties redissonProperties;
    @Autowired
    private RedisProperties redisProperties;
    @Autowired
    private ApplicationContext ctx;

    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public RedisConnectionFactory redisConnectionFactory(RedissonClient redisson) {
        return new RedissonConnectionFactory(redisson);
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redisson() {
        RedissonClient redissonClient = Redisson.create((Config)this.createConfig(null));
        return Redisson.create((Config)this.createConfig(null));
    }

    public RedissonConnectionConfiguration createConfig(Integer dbIndex) {
        RedissonConnectionConfiguration redissonConnectionConfiguration;
        Method nodesMethod;
        int timeout;
        if (dbIndex == null) {
            dbIndex = this.redisProperties.getDatabase();
        }
        Method clusterMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getCluster");
        Method timeoutMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getTimeout");
        Object timeoutValue = ReflectionUtils.invokeMethod((Method)timeoutMethod, (Object)this.redisProperties);
        if (null == timeoutValue) {
            timeout = 0;
        } else if (!(timeoutValue instanceof Integer)) {
            nodesMethod = ReflectionUtils.findMethod(timeoutValue.getClass(), (String)"toMillis");
            timeout = ((Long)ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)timeoutValue)).intValue();
        } else {
            timeout = (Integer)timeoutValue;
        }
        if (!this.redissonProperties.judgeNull()) {
            try {
                redissonConnectionConfiguration = RedissonConnectionConfiguration.fromJSON(this.redissonProperties.toJSON());
            }
            catch (Exception e) {
                LOGGER.error("can not parse redissonConnectionConfiguration", (Throwable)e);
                throw new IllegalArgumentException("Can't parse redissonConnectionConfiguration", e);
            }
        } else if (this.redisProperties.getSentinel() != null) {
            nodesMethod = ReflectionUtils.findMethod(RedisProperties.Sentinel.class, (String)"getNodes");
            Object nodesValue = ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)this.redisProperties.getSentinel());
            String[] nodes = nodesValue instanceof String ? this.convert(Arrays.asList(((String)nodesValue).split(","))) : this.convert((List)nodesValue);
            redissonConnectionConfiguration = new RedissonConnectionConfiguration();
            ((SentinelServersConfig)redissonConnectionConfiguration.useSentinelServers().setMasterName(this.redisProperties.getSentinel().getMaster()).addSentinelAddress(nodes).setDatabase(dbIndex.intValue()).setConnectTimeout(timeout)).setPassword(this.redisProperties.getPassword());
        } else if (clusterMethod != null && ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties) != null) {
            Object clusterObject = ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties);
            Method method = ReflectionUtils.findMethod(clusterObject.getClass(), (String)"getNodes");
            List nodesObject = (List)ReflectionUtils.invokeMethod((Method)method, (Object)clusterObject);
            String[] nodes = this.convert(nodesObject);
            redissonConnectionConfiguration = new RedissonConnectionConfiguration();
            ((ClusterServersConfig)redissonConnectionConfiguration.useClusterServers().addNodeAddress(nodes).setConnectTimeout(timeout)).setPassword(this.redisProperties.getPassword());
        } else {
            redissonConnectionConfiguration = new RedissonConnectionConfiguration();
            String prefix = "redis://";
            Method method = ReflectionUtils.findMethod(RedisProperties.class, (String)"isSsl");
            if (method != null && ((Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)this.redisProperties)).booleanValue()) {
                prefix = "rediss://";
            }
            ((SingleServerConfig)redissonConnectionConfiguration.useSingleServer().setAddress(prefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setConnectTimeout(timeout)).setDatabase(dbIndex.intValue()).setPassword(this.redisProperties.getPassword());
        }
        return redissonConnectionConfiguration;
    }

    private String[] convert(List<String> nodesObject) {
        ArrayList<String> nodes = new ArrayList<String>(nodesObject.size());
        for (String node : nodesObject) {
            if (!node.startsWith("redis://") && !node.startsWith("rediss://")) {
                nodes.add("redis://" + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[nodes.size()]);
    }
}

