/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.handler;

import com.naah69.core.config.redisson.RedissonClientHelper;
import com.naah69.core.config.redisson.RedissonConnectionFactory;
import com.naah69.core.handler.ClusterHandler;
import com.naah69.core.handler.HandlerType;
import com.naah69.core.handler.RedisHandler;
import com.naah69.core.util.ApplicationContextUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

final class HandlerManager {
    private static final RedisTemplate<String, Object> REDIS_TEMPLATE = (RedisTemplate)ApplicationContextUtil.getContext().getBean("redisTemplate", RedisTemplate.class);
    private static final StringRedisTemplate STRING_REDIS_TEMPLATE = (StringRedisTemplate)ApplicationContextUtil.getContext().getBean("stringRedisTemplate", StringRedisTemplate.class);
    private static final String DEFAULT_KEY = "default";
    private static final int DEFAULT_DB_INDEX = ((RedisProperties)ApplicationContextUtil.getContext().getBean(RedisProperties.class)).getDatabase();
    private final ConcurrentMap<HandlerType, ConcurrentMap<String, RedisHandler>> container = this.initContainer();
    private final ClusterHandler clusterHandler = new ClusterHandler(REDIS_TEMPLATE);

    HandlerManager() {
    }

    String getDefaultKey() {
        return DEFAULT_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RedisHandler getHandler(String key, HandlerType type) {
        if (type == HandlerType.CLUSTER) {
            return this.clusterHandler;
        }
        ConcurrentMap map = (ConcurrentMap)this.container.get((Object)type);
        RedisHandler handler = (RedisHandler)map.get(key);
        if (handler != null) {
            return handler;
        }
        ConcurrentMap<HandlerType, ConcurrentMap<String, RedisHandler>> concurrentMap = this.container;
        synchronized (concurrentMap) {
            RedisHandler instance;
            handler = (RedisHandler)map.get(key);
            if (handler == null && (handler = map.putIfAbsent(key, instance = this.getHandlerInstance(key, type))) == null) {
                handler = instance;
            }
        }
        return handler;
    }

    RedisTemplate<String, Object> getDefaultRedisTemplate() {
        return REDIS_TEMPLATE;
    }

    StringRedisTemplate getDefaultStringRedisTemplate() {
        return STRING_REDIS_TEMPLATE;
    }

    static RedisConnectionFactory getConnectionFactory(int dbIndex) {
        RedisConnectionFactory redisConnectionFactory = (RedisConnectionFactory)ApplicationContextUtil.getContext().getBean(RedisConnectionFactory.class);
        if (redisConnectionFactory instanceof LettuceConnectionFactory) {
            ((LettuceConnectionFactory)redisConnectionFactory).setDatabase(dbIndex);
        } else if (redisConnectionFactory instanceof JedisConnectionFactory) {
            JedisConnectionFactory factory = (JedisConnectionFactory)redisConnectionFactory;
            if (factory.isRedisSentinelAware()) {
                RedisSentinelConfiguration sentinelConfiguration = factory.getSentinelConfiguration();
                if (sentinelConfiguration != null) {
                    sentinelConfiguration.setDatabase(dbIndex);
                }
            } else {
                RedisStandaloneConfiguration standaloneConfiguration = factory.getStandaloneConfiguration();
                if (standaloneConfiguration != null) {
                    standaloneConfiguration.setDatabase(dbIndex);
                }
            }
        } else if (redisConnectionFactory instanceof RedissonConnectionFactory) {
            redisConnectionFactory = new RedissonConnectionFactory(RedissonClientHelper.createClient(dbIndex));
        } else {
            throw new RuntimeException("no support connection factory");
        }
        return redisConnectionFactory;
    }

    static RedisTemplate<String, Object> createRedisTemplate(int dbIndex) {
        return HandlerManager.createTemplate(dbIndex, false);
    }

    static StringRedisTemplate createStringRedisTemplate(int dbIndex) {
        return (StringRedisTemplate)HandlerManager.createTemplate(dbIndex, true);
    }

    static RedisTemplate createTemplate(int dbIndex, boolean isString) {
        return HandlerManager.initRedisTemplate(HandlerManager.getConnectionFactory(dbIndex), isString);
    }

    static List<RedisTemplate> createTemplate(int dbIndex) {
        RedisConnectionFactory connectionFactory = HandlerManager.getConnectionFactory(dbIndex);
        return Arrays.asList(HandlerManager.initRedisTemplate(connectionFactory, false), HandlerManager.initRedisTemplate(connectionFactory, true));
    }

    private static RedisTemplate initRedisTemplate(RedisConnectionFactory factory, boolean isString) {
        RedisTemplate redisTemplate;
        if (isString) {
            redisTemplate = new StringRedisTemplate(factory);
        } else {
            redisTemplate = new RedisTemplate();
            redisTemplate.setKeySerializer(REDIS_TEMPLATE.getKeySerializer());
            redisTemplate.setValueSerializer(REDIS_TEMPLATE.getValueSerializer());
            redisTemplate.setHashKeySerializer(REDIS_TEMPLATE.getHashKeySerializer());
            redisTemplate.setHashValueSerializer(REDIS_TEMPLATE.getHashValueSerializer());
            redisTemplate.setConnectionFactory(factory);
            redisTemplate.afterPropertiesSet();
        }
        return redisTemplate;
    }

    private ConcurrentMap<HandlerType, ConcurrentMap<String, RedisHandler>> initContainer() {
        HandlerType[] types;
        String dbIndex = String.valueOf(DEFAULT_DB_INDEX);
        ConcurrentHashMap<HandlerType, ConcurrentMap<String, RedisHandler>> container = new ConcurrentHashMap<HandlerType, ConcurrentMap<String, RedisHandler>>(32);
        for (HandlerType type : types = HandlerType.values()) {
            ConcurrentHashMap<String, RedisHandler> handlerMap = new ConcurrentHashMap<String, RedisHandler>(256);
            container.put(type, handlerMap);
            if (type == HandlerType.REDISLOCK) continue;
            RedisHandler handler = this.getHandlerInstance(dbIndex, type);
            handlerMap.put(this.getDefaultKey(), Objects.requireNonNull(handler));
            handlerMap.put(dbIndex, handler);
        }
        return container;
    }

    private RedisHandler getHandlerInstance(String key, HandlerType type) {
        Class clz = type.getTypeClass();
        try {
            Constructor constructor = clz.getDeclaredConstructor(Integer.class);
            constructor.setAccessible(true);
            RedisHandler handler = type == HandlerType.REDISLOCK && DEFAULT_KEY.equalsIgnoreCase(key) ? (RedisHandler)constructor.newInstance(DEFAULT_DB_INDEX) : (RedisHandler)constructor.newInstance(Integer.valueOf(key));
            return handler;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

