/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.naah69.core.handler.HandlerManager;
import com.naah69.core.handler.RedisHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;

public final class HashHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private StringRedisTemplate stringRedisTemplate;
    private HashOperations<String, String, Object> hashOperations;
    private HashOperations<String, String, String> stringHashOperations;

    HashHandler(Integer dbIndex) {
        List<RedisTemplate> templateList = HandlerManager.createTemplate(dbIndex);
        this.redisTemplate = templateList.get(0);
        this.stringRedisTemplate = (StringRedisTemplate)templateList.get(1);
        this.hashOperations = this.redisTemplate.opsForHash();
        this.stringHashOperations = this.stringRedisTemplate.opsForHash();
    }

    public void putAsObj(String key, String hashKey, Object value) {
        this.hashOperations.put((Object)key, (Object)hashKey, value);
    }

    public void put(String key, String hashKey, String value) {
        this.stringHashOperations.put((Object)key, (Object)hashKey, (Object)value);
    }

    public Boolean putIfAbsentAsObj(String key, String hashKey, Object value) {
        return this.hashOperations.putIfAbsent((Object)key, (Object)hashKey, value);
    }

    public Boolean putIfAbsent(String key, String hashKey, String value) {
        return this.stringHashOperations.putIfAbsent((Object)key, (Object)hashKey, (Object)value);
    }

    public void putAllAsObj(String key, Map<String, Object> map) {
        this.hashOperations.putAll((Object)key, map);
    }

    public void putAll(String key, Map<String, String> map) {
        this.stringHashOperations.putAll((Object)key, map);
    }

    public <T> T getAsObj(String key, String hashKey) {
        return (T)this.hashOperations.get((Object)key, (Object)hashKey);
    }

    public <T> T getAsObj(Class<T> type, String key, String hashKey) {
        Object value = this.hashOperations.get((Object)key, (Object)hashKey);
        return (T)(value instanceof JSON ? JSONObject.toJavaObject((JSON)((JSON)value), type) : value);
    }

    public String get(String key, String hashKey) {
        return (String)this.stringHashOperations.get((Object)key, (Object)hashKey);
    }

    public List mgetAsObj(String key, String ... hashKeys) {
        return this.hashOperations.multiGet((Object)key, Arrays.asList(hashKeys));
    }

    public List<String> mget(String key, String ... hashKeys) {
        return this.stringHashOperations.multiGet((Object)key, Arrays.asList(hashKeys));
    }

    public Long removeAsObj(String key, String ... hashKeys) {
        return this.hashOperations.delete((Object)key, (Object[])hashKeys);
    }

    public Long remove(String key, String ... hashKeys) {
        return this.stringHashOperations.delete((Object)key, (Object[])hashKeys);
    }

    public Map<String, Object> entriesAsObj(String key) {
        return this.hashOperations.entries((Object)key);
    }

    public Map<String, String> entries(String key) {
        return this.stringHashOperations.entries((Object)key);
    }

    public Set keysAsObj(String key) {
        return this.hashOperations.keys((Object)key);
    }

    public Set<String> keys(String key) {
        return this.stringHashOperations.keys((Object)key);
    }

    public List valuesAsObj(String key) {
        return this.hashOperations.values((Object)key);
    }

    public List<String> values(String key) {
        return this.stringHashOperations.values((Object)key);
    }

    public Long lengthOfValue(String key, String hashKey) {
        return this.stringHashOperations.lengthOfValue((Object)key, (Object)hashKey);
    }

    public Long sizeAsObj(String key) {
        return this.hashOperations.size((Object)key);
    }

    public Long size(String key) {
        return this.stringHashOperations.size((Object)key);
    }

    public Boolean hasKeyAsObj(String key, String hashKey) {
        return this.hashOperations.hasKey((Object)key, (Object)hashKey);
    }

    public Boolean hasKey(String key, String hashKey) {
        return this.stringHashOperations.hasKey((Object)key, (Object)hashKey);
    }

    @Deprecated
    public Double increment(String key, String hashKey, Double data) {
        return this.stringHashOperations.increment((Object)key, (Object)hashKey, data.doubleValue());
    }

    @Deprecated
    public Long increment(String key, String hashKey, Long data) {
        return this.stringHashOperations.increment((Object)key, (Object)hashKey, data.longValue());
    }

    @Deprecated
    public Long increment(String key, String hashKey) {
        return this.stringHashOperations.increment((Object)key, (Object)hashKey, 1L);
    }

    @Deprecated
    public Double decrement(String key, String hashKey, Double data) {
        return this.stringHashOperations.increment((Object)key, (Object)hashKey, -data.doubleValue());
    }

    @Deprecated
    public Long decrement(String key, String hashKey, Long data) {
        return this.stringHashOperations.increment((Object)key, (Object)hashKey, -data.longValue());
    }

    @Deprecated
    public Long decrement(String key, String hashKey) {
        return this.stringHashOperations.increment((Object)key, (Object)hashKey, -1L);
    }

    public Cursor<Map.Entry<String, Object>> scanAsObj(String key, Long count, String pattern) {
        return this.hashOperations.scan((Object)key, ScanOptions.scanOptions().count(count.longValue()).match(pattern).build());
    }

    public Cursor<Map.Entry<String, String>> scan(String key, Long count, String pattern) {
        return this.stringHashOperations.scan((Object)key, ScanOptions.scanOptions().count(count.longValue()).match(pattern).build());
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }
}

