/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.naah69.core.handler.HandlerManager;
import com.naah69.core.handler.RedisHandler;
import com.naah69.core.util.ConvertUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;

public final class PubSubHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private volatile RedisConnection connection;

    PubSubHandler(Integer dbIndex) {
        this.redisTemplate = HandlerManager.createRedisTemplate(dbIndex);
        this.connection = this.redisTemplate.getRequiredConnectionFactory().getConnection();
    }

    public void publish(String channel, Object message) {
        this.redisTemplate.convertAndSend(channel, message);
    }

    public void subscribe(MessageListener listener, String ... channels) {
        this.connection.subscribe(listener, ConvertUtil.toByteArray(RedisSerializer.string(), channels));
    }

    public void pSubscribe(MessageListener listener, String ... patterns) {
        this.connection.pSubscribe(listener, ConvertUtil.toByteArray(RedisSerializer.string(), patterns));
    }

    public void addSubChannels(String ... channels) {
        Subscription subscription = this.connection.getSubscription();
        if (subscription != null && subscription.isAlive()) {
            subscription.subscribe(ConvertUtil.toByteArray(RedisSerializer.string(), channels));
        }
    }

    public void addPSubChannels(String ... patterns) {
        Subscription subscription = this.connection.getSubscription();
        if (subscription != null && subscription.isAlive()) {
            subscription.pSubscribe(ConvertUtil.toByteArray(RedisSerializer.string(), patterns));
        }
    }

    public void unsubscribe(String ... channels) {
        Subscription subscription = this.connection.getSubscription();
        if (subscription != null && subscription.isAlive()) {
            if (channels == null || channels.length == 0) {
                subscription.unsubscribe();
            } else {
                subscription.unsubscribe(ConvertUtil.toByteArray(RedisSerializer.string(), channels));
            }
        }
    }

    public void pUnsubscribe(String ... patterns) {
        Subscription subscription = this.connection.getSubscription();
        if (subscription != null && subscription.isAlive()) {
            if (patterns == null || patterns.length == 0) {
                subscription.pUnsubscribe();
            } else {
                subscription.pUnsubscribe(ConvertUtil.toByteArray(RedisSerializer.string(), patterns));
            }
        }
    }

    public List<String> getChannels() {
        return this.getChannelOrPatterns(true);
    }

    public List<String> getPatterns() {
        return this.getChannelOrPatterns(false);
    }

    public <T> T deserialize(byte[] bytes) {
        return (T)this.redisTemplate.getValueSerializer().deserialize(bytes);
    }

    public <T> T deserialize(Class<T> type, byte[] bytes) {
        Object value = this.redisTemplate.getValueSerializer().deserialize(bytes);
        return (T)(value instanceof JSON ? JSONObject.toJavaObject((JSON)((JSON)value), type) : value);
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    private List<String> getChannelOrPatterns(boolean isChannels) {
        Subscription subscription = this.connection.getSubscription();
        if (subscription != null && subscription.isAlive()) {
            Collection channels = isChannels ? subscription.getChannels() : subscription.getPatterns();
            ArrayList<String> list = new ArrayList<String>(channels.size());
            RedisSerializer serializer = RedisSerializer.string();
            for (byte[] channel : channels) {
                list.add((String)serializer.deserialize(channel));
            }
            return list;
        }
        return new ArrayList<String>();
    }
}

