/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.handler;

import com.naah69.core.handler.HandlerManager;
import com.naah69.core.handler.RedisHandler;
import java.util.Collection;
import java.util.Properties;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisServer;
import org.springframework.data.redis.core.RedisTemplate;

public final class SentinelHandler
implements RedisHandler {
    private RedisTemplate<String, Object> redisTemplate;
    private RedisConnectionFactory connectionFactory;

    SentinelHandler(Integer dbIndex) {
        this.redisTemplate = HandlerManager.createRedisTemplate(dbIndex);
        this.connectionFactory = this.redisTemplate.getRequiredConnectionFactory();
    }

    public void isOpen() {
        this.connectionFactory.getSentinelConnection().isOpen();
    }

    public void failover(String masterName) {
        this.connectionFactory.getSentinelConnection().failover((NamedNode)RedisNode.newRedisNode().withName(masterName).promotedAs(RedisNode.NodeType.MASTER).build());
    }

    public Collection<RedisServer> masters() {
        return this.connectionFactory.getSentinelConnection().masters();
    }

    public Collection<RedisServer> slaves(String masterName) {
        return this.connectionFactory.getSentinelConnection().slaves((NamedNode)RedisNode.newRedisNode().withName(masterName).promotedAs(RedisNode.NodeType.MASTER).build());
    }

    public void monitor(RedisServer master) {
        this.connectionFactory.getSentinelConnection().monitor(master);
    }

    public void monitor(String name, String ip, String port, String quorum) {
        Properties properties = new Properties();
        properties.setProperty("name", name);
        properties.setProperty("ip", ip);
        properties.setProperty("port", port);
        properties.setProperty("quorum", quorum);
        this.monitor(RedisServer.newServerFrom((Properties)properties));
    }

    public void remove(String masterName) {
        this.connectionFactory.getSentinelConnection().remove((NamedNode)RedisNode.newRedisNode().withName(masterName).promotedAs(RedisNode.NodeType.MASTER).build());
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }
}

