/*
 * Decompiled with CFR 0.152.
 */
package com.naah69.core.util;

import com.naah69.core.handler.BitmapHandler;
import com.naah69.core.handler.ClusterHandler;
import com.naah69.core.handler.CustomCommandHandler;
import com.naah69.core.handler.DBHandler;
import com.naah69.core.handler.GeoHandler;
import com.naah69.core.handler.HandlerManagerProxy;
import com.naah69.core.handler.HandlerType;
import com.naah69.core.handler.HashHandler;
import com.naah69.core.handler.HyperLogLogHandler;
import com.naah69.core.handler.KeyHandler;
import com.naah69.core.handler.ListHandler;
import com.naah69.core.handler.NumberHandler;
import com.naah69.core.handler.PubSubHandler;
import com.naah69.core.handler.RedisLockHandler;
import com.naah69.core.handler.ScriptHandler;
import com.naah69.core.handler.SentinelHandler;
import com.naah69.core.handler.SetHandler;
import com.naah69.core.handler.StringHandler;
import com.naah69.core.handler.ZsetHandler;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisUtil {
    private static final HandlerManagerProxy MANAGER = new HandlerManagerProxy();

    public static DBHandler getDBHandler() {
        return (DBHandler)MANAGER.getHandler(HandlerType.DB);
    }

    public static DBHandler getDBHandler(int dbIndex) {
        return (DBHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.DB);
    }

    public static KeyHandler getKeyHandler() {
        return (KeyHandler)MANAGER.getHandler(HandlerType.KEY);
    }

    public static KeyHandler getKeyHandler(int dbIndex) {
        return (KeyHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.KEY);
    }

    public static NumberHandler getNumberHandler() {
        return (NumberHandler)MANAGER.getHandler(HandlerType.NUMBER);
    }

    public static NumberHandler getNumberHandler(int dbIndex) {
        return (NumberHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.NUMBER);
    }

    public static StringHandler getStringHandler() {
        return (StringHandler)MANAGER.getHandler(HandlerType.STRING);
    }

    public static StringHandler getStringHandler(int dbIndex) {
        return (StringHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.STRING);
    }

    public static HashHandler getHashHandler() {
        return (HashHandler)MANAGER.getHandler(HandlerType.HASH);
    }

    public static HashHandler getHashHandler(int dbIndex) {
        return (HashHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.HASH);
    }

    public static ListHandler getListHandler() {
        return (ListHandler)MANAGER.getHandler(HandlerType.LIST);
    }

    public static ListHandler getListHandler(int dbIndex) {
        return (ListHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.LIST);
    }

    public static SetHandler getSetHandler() {
        return (SetHandler)MANAGER.getHandler(HandlerType.SET);
    }

    public static SetHandler getSetHandler(int dbIndex) {
        return (SetHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.SET);
    }

    public static ZsetHandler getZsetHandler() {
        return (ZsetHandler)MANAGER.getHandler(HandlerType.ZSET);
    }

    public static ZsetHandler getZsetHandler(int dbIndex) {
        return (ZsetHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.ZSET);
    }

    public static HyperLogLogHandler getHyperLogLogHandler() {
        return (HyperLogLogHandler)MANAGER.getHandler(HandlerType.HYPERLOGLOG);
    }

    public static HyperLogLogHandler getHyperLogLogHandler(int dbIndex) {
        return (HyperLogLogHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.HYPERLOGLOG);
    }

    public static BitmapHandler getBitmapHandler() {
        return (BitmapHandler)MANAGER.getHandler(HandlerType.BITMAP);
    }

    public static BitmapHandler getBitmapHandler(int dbIndex) {
        return (BitmapHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.BITMAP);
    }

    public static GeoHandler getGeoHandler() {
        return (GeoHandler)MANAGER.getHandler(HandlerType.GEO);
    }

    public static GeoHandler getGeoHandler(int dbIndex) {
        return (GeoHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.GEO);
    }

    public static ScriptHandler getScriptHandler() {
        return (ScriptHandler)MANAGER.getHandler(HandlerType.SCRIPT);
    }

    public static ScriptHandler getScriptHandler(int dbIndex) {
        return (ScriptHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.SCRIPT);
    }

    public static PubSubHandler getPubSubHandler() {
        return (PubSubHandler)MANAGER.getHandler(HandlerType.PUBSUB);
    }

    public static PubSubHandler getPubSubHandler(int dbIndex) {
        return (PubSubHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.PUBSUB);
    }

    public static RedisLockHandler getRedisLockHandler() {
        return (RedisLockHandler)MANAGER.getHandler(HandlerType.REDISLOCK);
    }

    public static RedisLockHandler getRedisLockHandler(int dbIndex) {
        return (RedisLockHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.REDISLOCK);
    }

    public static SentinelHandler getSentinelHandler() {
        return (SentinelHandler)MANAGER.getHandler(HandlerType.SENTINEL);
    }

    public static SentinelHandler getSentinelHandler(int dbIndex) {
        return (SentinelHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.SENTINEL);
    }

    public static ClusterHandler getClusterHandler() {
        return (ClusterHandler)MANAGER.getHandler(HandlerType.CLUSTER);
    }

    public static CustomCommandHandler getCustomCommandHandler() {
        return (CustomCommandHandler)MANAGER.getHandler(HandlerType.CUSTOMCOMMAND);
    }

    public static CustomCommandHandler getCustomCommandHandler(int dbIndex) {
        return (CustomCommandHandler)MANAGER.getHandler(String.valueOf(dbIndex), HandlerType.CUSTOMCOMMAND);
    }

    public static RedisTemplate<String, Object> getDefaultRedisTemplate() {
        return MANAGER.getDefaultRedisTemplate();
    }

    public static StringRedisTemplate getDefaultStringRedisTemplate() {
        return MANAGER.getDefaultStringRedisTemplate();
    }
}

