/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.CustomErrorMessageType;
import com.networknt.schema.ErrorMessageType;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.utils.StringUtils;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public abstract class ValidationMessageHandler {
    protected final boolean failFast;
    protected final String customMessage;
    protected final ResourceBundle resourceBundle;
    protected ValidatorTypeCode validatorType;
    protected ErrorMessageType errorMessageType;
    protected String schemaPath;
    protected JsonSchema parentSchema;

    protected ValidationMessageHandler(boolean failFast, ErrorMessageType errorMessageType, String customMessage, ResourceBundle resourceBundle, ValidatorTypeCode validatorType, JsonSchema parentSchema, String schemaPath) {
        this.failFast = failFast;
        this.errorMessageType = errorMessageType;
        this.customMessage = customMessage;
        this.resourceBundle = resourceBundle;
        this.validatorType = validatorType;
        this.schemaPath = schemaPath;
        this.parentSchema = parentSchema;
    }

    protected ValidationMessage buildValidationMessage(String at, String ... arguments) {
        MessageFormat messageFormat = new MessageFormat(this.resourceBundle.getString(this.getErrorMessageType().getErrorCodeValue()));
        ValidationMessage message = ValidationMessage.ofWithCustom(this.getValidatorType().getValue(), this.getErrorMessageType(), messageFormat, this.customMessage, at, this.schemaPath, arguments);
        if (this.failFast && this.isApplicator()) {
            throw new JsonSchemaException(message);
        }
        return message;
    }

    protected ValidationMessage constructValidationMessage(String messageKey, String at, String ... arguments) {
        MessageFormat messageFormat = new MessageFormat(this.resourceBundle.getString(messageKey));
        ValidationMessage message = new ValidationMessage.Builder().code(this.getErrorMessageType().getErrorCode()).path(at).schemaPath(this.schemaPath).arguments(arguments).format(messageFormat).type(this.getValidatorType().getValue()).customMessage(this.customMessage).build();
        if (this.failFast && this.isApplicator()) {
            throw new JsonSchemaException(message);
        }
        return message;
    }

    protected ValidatorTypeCode getValidatorType() {
        return this.validatorType;
    }

    protected ErrorMessageType getErrorMessageType() {
        return this.errorMessageType;
    }

    private boolean isApplicator() {
        return !this.isPartOfAnyOfMultipleType() && !this.isPartOfIfMultipleType() && !this.isPartOfNotMultipleType() && !this.isPartOfOneOfMultipleType();
    }

    private boolean isPartOfAnyOfMultipleType() {
        return this.parentSchema.schemaPath.contains("/" + ValidatorTypeCode.ANY_OF.getValue() + "/");
    }

    private boolean isPartOfIfMultipleType() {
        return this.parentSchema.schemaPath.contains("/" + ValidatorTypeCode.IF_THEN_ELSE.getValue() + "/");
    }

    private boolean isPartOfNotMultipleType() {
        return this.parentSchema.schemaPath.contains("/" + ValidatorTypeCode.NOT.getValue() + "/");
    }

    protected boolean isPartOfOneOfMultipleType() {
        return this.parentSchema.schemaPath.contains("/" + ValidatorTypeCode.ONE_OF.getValue() + "/");
    }

    protected void parseErrorCode(String errorCodeKey) {
        String errorCodeText;
        JsonNode errorCodeNode = this.parentSchema.getSchemaNode().get(errorCodeKey);
        if (errorCodeNode != null && errorCodeNode.isTextual() && StringUtils.isNotBlank(errorCodeText = errorCodeNode.asText())) {
            this.errorMessageType = CustomErrorMessageType.of(errorCodeText);
        }
    }

    protected void updateValidatorType(ValidatorTypeCode validatorTypeCode) {
        this.validatorType = validatorTypeCode;
        this.errorMessageType = validatorTypeCode;
        this.parseErrorCode(validatorTypeCode.getErrorCodeKey());
    }
}

