/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.uri;

import com.networknt.schema.uri.URIFetcher;
import com.networknt.schema.uri.URLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;

public final class URLFetcher
implements URIFetcher {
    public static final Set<String> SUPPORTED_SCHEMES = URLFactory.SUPPORTED_SCHEMES;

    @Override
    public InputStream fetch(URI uri) throws IOException {
        URLConnection conn = uri.toURL().openConnection();
        return this.openConnectionCheckRedirects(conn);
    }

    private InputStream openConnectionCheckRedirects(URLConnection c) throws IOException {
        boolean redir;
        int redirects = 0;
        InputStream in = null;
        do {
            HttpURLConnection http;
            int stat;
            if (c instanceof HttpURLConnection) {
                ((HttpURLConnection)c).setInstanceFollowRedirects(false);
            }
            in = c.getInputStream();
            redir = false;
            if (!(c instanceof HttpURLConnection) || (stat = (http = (HttpURLConnection)c).getResponseCode()) < 300 || stat > 307 || stat == 306 || stat == 304) continue;
            URL base = http.getURL();
            String loc = http.getHeaderField("Location");
            URL target = null;
            if (loc != null) {
                target = new URL(base, loc);
            }
            http.disconnect();
            if (target == null || !target.getProtocol().equals("http") && !target.getProtocol().equals("https") || redirects >= 5) {
                throw new SecurityException("illegal URL redirect");
            }
            redir = true;
            c = target.openConnection();
            ++redirects;
        } while (redir);
        return in;
    }
}

