/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPSchema;
import com.novell.ldap.LDAPSchemaElement;
import com.novell.ldap.client.AttributeQualifier;
import com.novell.ldap.client.SchemaParser;
import com.novell.ldap.util.LDAPXMLHandler;
import com.novell.ldap.util.SAXEventMultiplexer;
import com.novell.ldap.util.ValueXMLhandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LDAPDITContentRuleSchema
extends LDAPSchemaElement {
    private String[] auxiliary = new String[]{""};
    private String[] required = new String[]{""};
    private String[] optional = new String[]{""};
    private String[] precluded = new String[]{""};

    public LDAPDITContentRuleSchema() {
        super(LDAPSchema.schemaTypeNames[4]);
    }

    public LDAPDITContentRuleSchema(String[] stringArray, String string, String string2, boolean bl, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) {
        super(LDAPSchema.schemaTypeNames[4]);
        this.names = (String[])stringArray.clone();
        this.oid = string;
        this.description = string2;
        this.obsolete = bl;
        this.auxiliary = stringArray2;
        this.required = stringArray3;
        this.optional = stringArray4;
        this.precluded = stringArray5;
        super.setValue(this.formatString());
    }

    public LDAPDITContentRuleSchema(String string) {
        super(LDAPSchema.schemaTypeNames[4]);
        this.obsolete = false;
        try {
            SchemaParser schemaParser = new SchemaParser(string);
            if (schemaParser.getNames() != null) {
                this.names = (String[])schemaParser.getNames().clone();
            }
            if (schemaParser.getID() != null) {
                this.oid = schemaParser.getID();
            }
            if (schemaParser.getDescription() != null) {
                this.description = schemaParser.getDescription();
            }
            if (schemaParser.getAuxiliary() != null) {
                this.auxiliary = (String[])schemaParser.getAuxiliary().clone();
            }
            if (schemaParser.getRequired() != null) {
                this.required = (String[])schemaParser.getRequired().clone();
            }
            if (schemaParser.getOptional() != null) {
                this.optional = (String[])schemaParser.getOptional().clone();
            }
            if (schemaParser.getPrecluded() != null) {
                this.precluded = (String[])schemaParser.getPrecluded().clone();
            }
            this.obsolete = schemaParser.getObsolete();
            Enumeration enumeration = schemaParser.getQualifiers();
            while (enumeration.hasMoreElements()) {
                AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                this.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
            }
            super.setValue(this.formatString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String[] getAuxiliaryClasses() {
        return this.auxiliary;
    }

    public String[] getRequiredAttributes() {
        return this.required;
    }

    public String[] getOptionalAttributes() {
        return this.optional;
    }

    public String[] getPrecludedAttributes() {
        return this.precluded;
    }

    protected String formatString() {
        Enumeration enumeration;
        int n;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer("( ");
        String string = this.getID();
        if (string != null) {
            stringBuffer.append(string);
        }
        if ((stringArray = this.getNames()) != null) {
            stringBuffer.append(" NAME ");
            if (stringArray.length == 1) {
                stringBuffer.append("'" + stringArray[0] + "'");
            } else {
                stringBuffer.append("( ");
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(" '" + stringArray[n] + "'");
                }
                stringBuffer.append(" )");
            }
        }
        if ((string = this.getDescription()) != null) {
            stringBuffer.append(" DESC ");
            stringBuffer.append("'" + string + "'");
        }
        if (this.isObsolete()) {
            stringBuffer.append(" OBSOLETE");
        }
        if ((stringArray = this.getAuxiliaryClasses()) != null) {
            stringBuffer.append(" AUX ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((stringArray = this.getRequiredAttributes()) != null) {
            stringBuffer.append(" MUST ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((stringArray = this.getOptionalAttributes()) != null) {
            stringBuffer.append(" MAY ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((stringArray = this.getPrecludedAttributes()) != null) {
            stringBuffer.append(" NOT ");
            if (stringArray.length > 1) {
                stringBuffer.append("( ");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (n > 0) {
                    stringBuffer.append(" $ ");
                }
                stringBuffer.append(stringArray[n]);
            }
            if (stringArray.length > 1) {
                stringBuffer.append(" )");
            }
        }
        if ((enumeration = this.getQualifierNames()) != null) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                stringBuffer.append(" " + string2 + " ");
                String[] stringArray2 = this.getQualifier(string2);
                if (stringArray2 == null) continue;
                if (stringArray2.length > 1) {
                    stringBuffer.append("( ");
                }
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append("'" + stringArray2[i] + "'");
                }
                if (stringArray2.length <= 1) continue;
                stringBuffer.append(" )");
            }
        }
        stringBuffer.append(" )");
        return stringBuffer.toString();
    }

    protected void setDeserializedValues(BufferedInputStream bufferedInputStream) throws IOException {
        LDAPDITContentRuleSchema lDAPDITContentRuleSchema = (LDAPDITContentRuleSchema)LDAPDITContentRuleSchema.readDSML(bufferedInputStream);
        this.oid = lDAPDITContentRuleSchema.getID();
        this.names = lDAPDITContentRuleSchema.getNames();
        this.description = lDAPDITContentRuleSchema.getDescription();
        this.obsolete = lDAPDITContentRuleSchema.isObsolete();
        Enumeration enumeration = lDAPDITContentRuleSchema.getQualifierNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = lDAPDITContentRuleSchema.getQualifier(string);
            this.setQualifier(string, stringArray);
        }
        super.setValue(this.formatString());
        this.auxiliary = lDAPDITContentRuleSchema.getAuxiliaryClasses();
        this.required = lDAPDITContentRuleSchema.getRequiredAttributes();
        this.optional = lDAPDITContentRuleSchema.getOptionalAttributes();
        this.precluded = lDAPDITContentRuleSchema.getPrecludedAttributes();
        lDAPDITContentRuleSchema = null;
    }

    protected void writeValue(Writer writer) throws IOException {
        String string = this.formatString();
        writer.write(ValueXMLhandler.newLine(2));
        writer.write("<value>");
        writer.write(string);
        writer.write("</value>");
    }

    protected void writeValue(StringBuffer stringBuffer) {
        String string = this.formatString();
        stringBuffer.append(ValueXMLhandler.newLine(2));
        stringBuffer.append("<value>");
        stringBuffer.append(string);
        stringBuffer.append("</value>");
    }

    public static Object readDSML(InputStream inputStream) throws IOException {
        SAXEventMultiplexer sAXEventMultiplexer = new SAXEventMultiplexer();
        sAXEventMultiplexer.setLDAPXMLHandler(LDAPDITContentRuleSchema.getTopXMLHandler("LDAPAttribute", null));
        return (LDAPDITContentRuleSchema)sAXEventMultiplexer.parseXML(inputStream);
    }

    private static LDAPXMLHandler getTopXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(LDAPDITContentRuleSchema.getXMLHandler("attr", this));
            }

            protected void endElement() {
                this.setObject((LDAPDITContentRuleSchema)this.valuelist.get(0));
            }

            protected void addValue(String string, Object object) {
                if (string.equals("attr")) {
                    this.valuelist.add(object);
                }
            }
        };
    }

    static LDAPXMLHandler getXMLHandler(String string, LDAPXMLHandler lDAPXMLHandler) {
        return new LDAPXMLHandler(string, lDAPXMLHandler){
            String attrName;
            List valuelist = new ArrayList();

            protected void initHandler() {
                this.setchildelement(new ValueXMLhandler(this));
            }

            protected void endElement() {
                Iterator iterator = this.valuelist.iterator();
                LDAPDITContentRuleSchema lDAPDITContentRuleSchema = new LDAPDITContentRuleSchema(this.attrName);
                byte[] byArray = (byte[])iterator.next();
                StringBuffer stringBuffer = new StringBuffer(byArray.length);
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuffer.append((char)byArray[i]);
                }
                try {
                    SchemaParser schemaParser = new SchemaParser(stringBuffer.toString());
                    if (schemaParser.getNames() != null) {
                        lDAPDITContentRuleSchema.names = (String[])schemaParser.getNames().clone();
                    }
                    if (schemaParser.getID() != null) {
                        lDAPDITContentRuleSchema.oid = schemaParser.getID();
                    }
                    if (schemaParser.getDescription() != null) {
                        lDAPDITContentRuleSchema.description = schemaParser.getDescription();
                    }
                    if (schemaParser.getAuxiliary() != null) {
                        LDAPDITContentRuleSchema.access$002(lDAPDITContentRuleSchema, (String[])schemaParser.getAuxiliary().clone());
                    }
                    if (schemaParser.getRequired() != null) {
                        LDAPDITContentRuleSchema.access$102(lDAPDITContentRuleSchema, (String[])schemaParser.getRequired().clone());
                    }
                    if (schemaParser.getOptional() != null) {
                        LDAPDITContentRuleSchema.access$202(lDAPDITContentRuleSchema, (String[])schemaParser.getOptional().clone());
                    }
                    if (schemaParser.getPrecluded() != null) {
                        LDAPDITContentRuleSchema.access$302(lDAPDITContentRuleSchema, (String[])schemaParser.getPrecluded().clone());
                    }
                    lDAPDITContentRuleSchema.obsolete = schemaParser.getObsolete();
                    Enumeration enumeration = schemaParser.getQualifiers();
                    while (enumeration.hasMoreElements()) {
                        AttributeQualifier attributeQualifier = (AttributeQualifier)enumeration.nextElement();
                        lDAPDITContentRuleSchema.setQualifier(attributeQualifier.getName(), attributeQualifier.getValues());
                    }
                    lDAPDITContentRuleSchema.setValue(lDAPDITContentRuleSchema.formatString());
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.toString());
                }
                this.setObject(lDAPDITContentRuleSchema);
                this.valuelist.clear();
            }

            protected void addValue(String string, Object object) {
                if (string.equals("value")) {
                    this.valuelist.add(object);
                }
            }

            protected void handleAttributes(Attributes attributes) throws SAXException {
                this.attrName = attributes.getValue("name");
                if (this.attrName == null) {
                    throw new SAXException("invalid attr Tag, name is mandatory element: ");
                }
            }
        };
    }

    static /* synthetic */ String[] access$002(LDAPDITContentRuleSchema lDAPDITContentRuleSchema, String[] stringArray) {
        lDAPDITContentRuleSchema.auxiliary = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$102(LDAPDITContentRuleSchema lDAPDITContentRuleSchema, String[] stringArray) {
        lDAPDITContentRuleSchema.required = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$202(LDAPDITContentRuleSchema lDAPDITContentRuleSchema, String[] stringArray) {
        lDAPDITContentRuleSchema.optional = stringArray;
        return stringArray;
    }

    static /* synthetic */ String[] access$302(LDAPDITContentRuleSchema lDAPDITContentRuleSchema, String[] stringArray) {
        lDAPDITContentRuleSchema.precluded = stringArray;
        return stringArray;
    }
}

