/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.xa.client.OracleXAResource;

public class OracleXAConnection
extends oracle.jdbc.xa.OracleXAConnection {
    protected boolean isXAResourceTransLoose = false;

    public OracleXAConnection() throws XAException {
    }

    public OracleXAConnection(Connection pc) throws XAException {
        super(pc);
    }

    @Override
    public XAResource getXAResource() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            try {
                if (this.xaResource == null) {
                    this.xaResource = new OracleXAResource(this.physicalConn, this);
                    ((OracleXAResource)this.xaResource).isTransLoose = this.isXAResourceTransLoose;
                    if (this.logicalHandle != null) {
                        ((oracle.jdbc.xa.OracleXAResource)this.xaResource).setLogicalConnection(this.logicalHandle);
                    }
                }
            }
            catch (XAException xae) {
                this.xaResource = null;
                if (xae.getCause() instanceof SQLException) {
                    throw (SQLException)xae.getCause();
                }
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), xae);
            }
            XAResource xAResource = this.xaResource;
            return xAResource;
        }
    }
}

