/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.TNSAddress;

import java.util.Vector;
import oracle.net.jdbc.TNSAddress.SOException;
import oracle.net.jdbc.TNSAddress.SchemaObject;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.jdbc.nl.InvalidSyntaxException;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.resolver.TimeUnitSuffixUtility;

public class Description
implements SchemaObject {
    protected Vector children = new Vector();
    private SchemaObject child;
    private NVPair childnv;
    private SchemaObjectFactoryInterface f = null;
    protected boolean sourceRoute = false;
    protected boolean loadBalance = false;
    protected boolean failover = true;
    protected boolean keepAlive = false;
    protected String SDU;
    protected String TDU;
    protected Vector protocolStacks = new Vector();
    protected String httpsProxy;
    protected String httpsProxyPort;
    protected String sendBufSize;
    protected String receiveBufSize;
    protected String connectData;
    protected String SID;
    protected String server;
    protected String failoverMode;
    protected String instanceRole;
    protected String serviceName;
    protected String instanceName;
    protected String handlerName;
    protected String oracleHome;
    protected String connectTimeout;
    protected String transportTimeout;
    protected String retryCount;
    protected String expireTime;
    protected String netConnectionIdPrefix;
    protected String useTcpFastOpen;
    protected String authTypes;
    protected String sslServerCertDN;
    protected String sslServerDNMatch;
    protected String sslAllowWeakDNMatch;
    protected String myWalletDirectory;
    protected String sslVersion;
    protected String sslCertAlias;
    protected String sslCertThumbprint;
    private Vector authParams = new Vector();
    protected String encryptionClient;
    protected String encryptionClientTypes;
    protected String checksumClient;
    protected String checksumClientTypes;
    protected String allowWeakCrypto;
    protected String descriptionString;
    protected String tokenAuthentication;
    protected String tokenLocation;
    protected String passwordAuthentication;
    protected String ociIamUrl;
    protected String ociTenancy;
    protected String ociCompartment;
    protected String ociDatabase;
    protected String ociConfigFile;
    protected String ociProfile;
    protected String azureDbAppIdUri;
    protected String tenantId;
    protected String clientId;
    protected String clientCertificate;
    protected String redirectUri;
    private Vector extraConnInfo = new Vector();
    private Vector extraInfo = new Vector();
    protected int delayInMillis = -1;
    protected String BEQServerProcessEnvironmentVars = null;
    protected String BEQServerProcessArguments = null;

    public Description(SchemaObjectFactoryInterface f) {
        this.f = f;
    }

    @Override
    public int isA() {
        return 2;
    }

    @Override
    public String isA_String() {
        return "DESCRIPTION";
    }

    @Override
    public void initFromString(String s) throws NLException, SOException, NetException {
        NVPair nvp = new NVFactory().createNVPair(s);
        this.initFromNVPair(nvp);
    }

    @Override
    public void initFromNVPair(NVPair nvp) throws SOException, NetException {
        this.init();
        int listsize = nvp.getListSize();
        if (listsize == 0) {
            throw new SOException();
        }
        this.descriptionString = nvp.toString();
        for (int i = 0; i < listsize; ++i) {
            int j;
            this.childnv = nvp.getListElement(i);
            if (this.childnv.getName().equalsIgnoreCase("SOURCE_ROUTE")) {
                this.sourceRoute = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("LOAD_BALANCE")) {
                this.loadBalance = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("FAILOVER")) {
                this.failover = this.childnv.getAtom().equalsIgnoreCase("yes") || this.childnv.getAtom().equalsIgnoreCase("on") || this.childnv.getAtom().equalsIgnoreCase("true");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ENABLE")) {
                this.keepAlive = this.childnv.getAtom().equalsIgnoreCase("broken");
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("PROTOCOL_STACK")) {
                this.protocolStacks.addElement(this.childnv.toString());
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS")) {
                this.child = this.f.create(0);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ADDRESS_LIST")) {
                this.child = this.f.create(1);
                this.child.initFromNVPair(this.childnv);
                this.children.addElement(this.child);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SDU")) {
                this.SDU = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("TDU")) {
                this.TDU = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SEND_BUF_SIZE")) {
                this.sendBufSize = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RECV_BUF_SIZE")) {
                this.receiveBufSize = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("HTTPS_PROXY")) {
                this.httpsProxy = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("HTTPS_PROXY_PORT")) {
                this.httpsProxyPort = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("CONNECT_DATA")) {
                this.connectData = this.childnv.valueToString();
                int cdlistsize = this.childnv.getListSize();
                if (cdlistsize == 0) {
                    throw new SOException();
                }
                for (j = 0; j < cdlistsize; ++j) {
                    NVPair cdlistnv = this.childnv.getListElement(j);
                    if (cdlistnv.getName().equalsIgnoreCase("SID")) {
                        this.SID = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("SERVER")) {
                        this.server = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("SERVICE_NAME")) {
                        this.serviceName = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("INSTANCE_NAME")) {
                        this.instanceName = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("HANDLER_NAME")) {
                        this.handlerName = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("ORACLE_HOME")) {
                        this.oracleHome = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("FAILOVER_MODE")) {
                        this.failoverMode = this.childnv.getListElement(j).toString();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("INSTANCE_ROLE")) {
                        this.instanceRole = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("CONNECTION_ID_PREFIX")) {
                        this.netConnectionIdPrefix = cdlistnv.getAtom();
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("USE_TCP_FAST_OPEN")) {
                        this.setUseTcpFastOpen("USE_TCP_FAST_OPEN", cdlistnv.getAtom());
                        continue;
                    }
                    if (cdlistnv.getName().equalsIgnoreCase("TFO")) {
                        this.setUseTcpFastOpen("TFO", cdlistnv.getAtom());
                        continue;
                    }
                    String param = cdlistnv.toString().trim();
                    param = param.substring(1, param.length() - 1);
                    this.extraConnInfo.addElement(param);
                }
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RETRY_DELAY")) {
                this.delayInMillis = TimeUnitSuffixUtility.getTimeInMilliseconds(this.childnv.getAtom(), true);
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("SECURITY")) {
                int slistsize = this.childnv.getListSize();
                if (slistsize == 0) {
                    throw new SOException();
                }
                for (j = 0; j < slistsize; ++j) {
                    NVPair slistnv = this.childnv.getListElement(j);
                    if (slistnv.getName().equalsIgnoreCase("AUTHENTICATION")) {
                        this.authTypes = slistnv.toString();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("ssl_server_cert_dn")) {
                        this.sslServerCertDN = slistnv.getAtom();
                        if (this.sslServerCertDN == null || !this.sslServerCertDN.startsWith("\"") || !this.sslServerCertDN.endsWith("\"")) continue;
                        this.sslServerCertDN = this.sslServerCertDN.substring(1, this.sslServerCertDN.length() - 1);
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("ssl_server_dn_match")) {
                        this.sslServerDNMatch = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("ssl_allow_weak_dn_match")) {
                        this.sslAllowWeakDNMatch = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("wallet_location")) {
                        this.myWalletDirectory = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("my_wallet_directory") && this.myWalletDirectory == null) {
                        this.myWalletDirectory = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("ssl_version")) {
                        this.sslVersion = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("ssl_certificate_alias")) {
                        this.sslCertAlias = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("ssl_certificate_thumbprint")) {
                        this.sslCertThumbprint = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("encryption_client")) {
                        this.encryptionClient = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("encryption_types_client")) {
                        this.encryptionClientTypes = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("crypto_checksum_client")) {
                        this.checksumClient = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("crypto_checksum_types_client")) {
                        this.checksumClientTypes = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("allow_weak_crypto")) {
                        this.allowWeakCrypto = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("token_auth")) {
                        this.tokenAuthentication = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("token_location")) {
                        this.tokenLocation = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("password_auth")) {
                        this.passwordAuthentication = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("oci_iam_url")) {
                        this.ociIamUrl = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("oci_tenancy")) {
                        this.ociTenancy = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("oci_compartment")) {
                        this.ociCompartment = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("oci_database")) {
                        this.ociDatabase = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("oci_config_file")) {
                        this.ociConfigFile = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("oci_profile")) {
                        this.ociProfile = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("azure_db_app_id_uri")) {
                        this.azureDbAppIdUri = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("tenant_id")) {
                        this.tenantId = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("client_id")) {
                        this.clientId = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("client_certificate")) {
                        this.clientCertificate = slistnv.getAtom();
                        continue;
                    }
                    if (slistnv.getName().equalsIgnoreCase("redirect_uri")) {
                        this.redirectUri = slistnv.getAtom();
                        continue;
                    }
                    this.authParams.addElement(slistnv.toString());
                }
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("CONNECT_TIMEOUT")) {
                this.connectTimeout = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("TRANSPORT_CONNECT_TIMEOUT")) {
                this.transportTimeout = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("RETRY_COUNT")) {
                this.retryCount = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("EXPIRE_TIME")) {
                this.expireTime = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ENVS")) {
                this.BEQServerProcessEnvironmentVars = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("ARGS")) {
                this.BEQServerProcessArguments = this.childnv.getAtom();
                continue;
            }
            if (this.childnv.getName().equalsIgnoreCase("HS") && this.childnv.getAtom() == null) {
                try {
                    this.childnv.setAtom("OK");
                }
                catch (InvalidSyntaxException slistsize) {
                    // empty catch block
                }
            }
            String param = this.childnv.toString().trim();
            param = param.substring(1, param.length() - 1);
            this.extraInfo.addElement(param);
        }
    }

    private void setUseTcpFastOpen(String key, String value) throws NetException {
        if (!SQLnetDef.isValidTcpFastOpenValue(value)) {
            throw new NetException(17877, null, false, key, value);
        }
        this.useTcpFastOpen = value;
    }

    @Override
    public String toString() {
        int i;
        String s = new String("");
        String child = new String("");
        for (i = 0; i < this.children.size(); ++i) {
            child = ((SchemaObject)this.children.elementAt(i)).toString();
            if (child.equals("")) continue;
            s = s + child;
        }
        if (!s.equals("") && this.sourceRoute) {
            s = s + "(SOURCE_ROUTE=yes)";
        }
        if (!s.equals("") && this.loadBalance) {
            s = s + "(LOAD_BALANCE=yes)";
        }
        if (!s.equals("") && !this.failover) {
            s = s + "(FAILOVER=false)";
        }
        if (this.keepAlive) {
            s = s + "(ENABLE=broken)";
        }
        if (this.SDU != null) {
            s = s + "(SDU=" + this.SDU + ")";
        }
        if (this.TDU != null) {
            s = s + "(TDU=" + this.TDU + ")";
        }
        if (this.sendBufSize != null) {
            s = s + "(SEND_BUF_SIZE=" + this.sendBufSize + ")";
        }
        if (this.receiveBufSize != null) {
            s = s + "(RECV_BUF_SIZE=" + this.receiveBufSize + ")";
        }
        if (this.protocolStacks.size() != 0) {
            for (i = 0; i < this.protocolStacks.size(); ++i) {
                s = s + (String)this.protocolStacks.elementAt(i);
            }
        }
        if (this.SID != null || this.server != null || this.serviceName != null || this.instanceName != null || this.handlerName != null || this.extraConnInfo.size() != 0 || this.oracleHome != null) {
            s = s + "(CONNECT_DATA=";
            if (this.SID != null) {
                s = s + "(SID=" + this.SID + ")";
            }
            if (this.server != null) {
                s = s + "(SERVER=" + this.server + ")";
            }
            if (this.serviceName != null) {
                s = s + "(SERVICE_NAME=" + this.serviceName + ")";
            }
            if (this.instanceName != null) {
                s = s + "(INSTANCE_NAME=" + this.instanceName + ")";
            }
            if (this.handlerName != null) {
                s = s + "(HANDLER_NAME=" + this.handlerName + ")";
            }
            if (this.oracleHome != null) {
                s = s + "(ORACLE_HOME=" + this.oracleHome + ")";
            }
            if (this.instanceRole != null) {
                s = s + "(INSTANCE_ROLE=" + this.instanceRole + ")";
            }
            if (this.failoverMode != null) {
                s = s + this.failoverMode;
            }
            for (i = 0; i < this.extraConnInfo.size(); ++i) {
                s = s + "(" + (String)this.extraConnInfo.elementAt(i) + ")";
            }
            s = s + ")";
        }
        if (this.authTypes != null || this.authParams.size() != 0) {
            s = s + "(SECURITY=";
            if (this.authTypes != null) {
                s = s + "(AUTHENTICATION=" + this.authTypes + ")";
            }
            for (i = 0; i < this.authParams.size(); ++i) {
                s = s + (String)this.authParams.elementAt(i);
            }
            s = s + ")";
        }
        for (i = 0; i < this.extraInfo.size(); ++i) {
            s = s + "(" + (String)this.extraInfo.elementAt(i) + ")";
        }
        if (!s.equals("")) {
            s = "(DESCRIPTION=" + s + ")";
        }
        return s;
    }

    protected void init() {
        this.children.removeAllElements();
        this.child = null;
        this.childnv = null;
        this.sourceRoute = false;
        this.loadBalance = false;
        this.failover = true;
        this.keepAlive = false;
        this.protocolStacks.removeAllElements();
        this.SDU = null;
        this.TDU = null;
        this.SID = null;
        this.httpsProxy = null;
        this.httpsProxyPort = null;
        this.server = null;
        this.serviceName = null;
        this.instanceName = null;
        this.handlerName = null;
        this.oracleHome = null;
        this.authTypes = null;
        this.sendBufSize = null;
        this.receiveBufSize = null;
        this.failoverMode = null;
        this.instanceRole = null;
        this.authParams.removeAllElements();
        this.extraConnInfo.removeAllElements();
        this.extraInfo.removeAllElements();
    }
}

