/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBean;
import oracle.ucp.admin.UniversalConnectionPoolManagerMBeanImpl;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceFactory;
import oracle.ucp.jdbc.UCPDataSourceResource;
import oracle.ucp.jdbc.UCPResource;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
@WebListener
class UCPServletContextListener
implements ServletContextListener {
    private PoolDataSource pds;
    private InitialContext initContext;
    private UniversalConnectionPoolManagerMBean managerMBean;
    static final String loggerName = "oracle.ucp.jdbc";
    private static final Logger logger;
    @Inject
    @UCPResource
    private UCPDataSourceResource ucpDataSourceResource;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    UCPServletContextListener() {
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext context = servletContextEvent.getServletContext();
        try {
            if (System.getProperty("oracle.ucp.jdbc.xmlConfigFile") == null) {
                this.pds = PoolDataSourceFactory.getPoolDataSource();
                Enumeration parameterNames = context.getInitParameterNames();
                while (parameterNames.hasMoreElements()) {
                    String parameter = (String)parameterNames.nextElement();
                    try {
                        Class parameterType = null;
                        Object value = null;
                        switch (parameter) {
                            case "ucp.connectionPoolName": 
                            case "ucp.connectionFactoryClassName": 
                            case "ucp.URL": 
                            case "ucp.user": 
                            case "ucp.password": 
                            case "ucp.serverName": 
                            case "ucp.databaseName": 
                            case "ucp.dataSourceName": 
                            case "ucp.description": 
                            case "ucp.networkProtocol": 
                            case "ucp.roleName": 
                            case "ucp.sqlForValidateConnection": 
                            case "ucp.onsConfiguration": {
                                parameterType = String.class;
                                value = context.getInitParameter(parameter);
                                break;
                            }
                            case "ucp.portNumber": 
                            case "ucp.initialPoolSize": 
                            case "ucp.maxPoolSize": 
                            case "ucp.minPoolSize": 
                            case "ucp.abandonedConnectionTimeout": 
                            case "ucp.timeToLiveConnectionTimeout": 
                            case "ucp.inactiveConnectionTimeout": 
                            case "ucp.maxIdleTime": 
                            case "ucp.timeoutCheckInterval": 
                            case "ucp.propertyCycle": 
                            case "ucp.maxStatements": 
                            case "ucp.connectionWaitTimeout": 
                            case "ucp.maxConnectionReuseCount": 
                            case "ucp.connectionHarvestTriggerCount": 
                            case "ucp.connectionHarvestMaxCount": 
                            case "ucp.secondsToTrustIdleConnection": 
                            case "ucp.connectionLabelingHighCost": 
                            case "ucp.connectionRepurposeThreshold": 
                            case "ucp.highCostConnectionReuseThreshold": 
                            case "ucp.maxConnectionsPerShard": 
                            case "ucp.connectionValidationTimeout": {
                                parameterType = Integer.TYPE;
                                value = Integer.valueOf(context.getInitParameter(parameter));
                                break;
                            }
                            case "ucp.maxConnectionReuseTime": {
                                parameterType = Long.TYPE;
                                value = Long.valueOf(context.getInitParameter(parameter));
                                break;
                            }
                            case "ucp.validateConnectionOnBorrow": 
                            case "ucp.fastConnectionFailoverEnabled": 
                            case "ucp.shardingMode": {
                                parameterType = Boolean.TYPE;
                                value = Boolean.valueOf(context.getInitParameter(parameter));
                            }
                        }
                        if (parameterType == null) continue;
                        PoolDataSource.class.getMethod("set" + parameter.substring(4, 5).toUpperCase() + parameter.substring(5), parameterType).invoke((Object)this.pds, value);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                        logger.severe(exception.getMessage());
                        throw new RuntimeException(exception);
                    }
                }
            } else {
                this.pds = PoolDataSourceFactory.getPoolDataSource(context.getInitParameter("ucp.dataSourceName"));
            }
            this.managerMBean = UniversalConnectionPoolManagerMBeanImpl.getUniversalConnectionPoolManagerMBean();
            this.managerMBean.createConnectionPool((UniversalConnectionPoolAdapter)((Object)this.pds));
            this.managerMBean.startConnectionPool(this.pds.getConnectionPoolName());
            this.ucpDataSourceResource.setPoolDataSource(this.pds);
            if (context.getInitParameter("ucp.jndiName") != null) {
                this.initContext = new InitialContext();
                this.initContext.bind(context.getInitParameter("ucp.jndiName"), (Object)this.ucpDataSourceResource);
            }
        }
        catch (SQLException | NamingException | UniversalConnectionPoolException exception) {
            logger.severe(exception.getMessage());
            throw new RuntimeException(exception);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            this.managerMBean.stopConnectionPool(this.pds.getConnectionPoolName());
            this.managerMBean.destroyConnectionPool(this.pds.getConnectionPoolName());
        }
        catch (UniversalConnectionPoolException exception) {
            logger.severe(exception.getMessage());
            throw new RuntimeException(exception);
        }
    }

    static {
        try {
            $$$methodRef$$$2 = UCPServletContextListener.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = UCPServletContextListener.class.getDeclaredMethod("contextDestroyed", ServletContextEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = UCPServletContextListener.class.getDeclaredMethod("contextInitialized", ServletContextEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        logger = Logger.getLogger(loggerName);
    }
}

