/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class OHttpMultipartBaseInputStream
extends InputStream {
    protected ArrayList<Integer> buffer;
    protected int contentLength = 0;
    protected InputStream wrappedInputStream;

    public OHttpMultipartBaseInputStream(InputStream in, int iSkipInput, int iContentLength) {
        this.wrappedInputStream = in;
        this.contentLength = iContentLength;
        this.buffer = new ArrayList();
        this.buffer.add(iSkipInput);
    }

    public InputStream getWrappedInputStream() {
        return this.wrappedInputStream;
    }

    public void setSkipInput(int iSkipInput) {
        this.buffer.add(iSkipInput);
        ++this.contentLength;
    }

    public void setSkipInput(ArrayList<Integer> iSkipInput) {
        this.buffer.addAll(iSkipInput);
        this.contentLength += iSkipInput.size();
    }

    @Override
    public synchronized int available() throws IOException {
        return this.contentLength;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.contentLength < 1) {
            return -1;
        }
        --this.contentLength;
        if (this.buffer.size() > 0) {
            int returnValue = this.buffer.remove(0);
            return returnValue;
        }
        return this.wrappedInputStream.read();
    }

    @Override
    public void close() throws IOException {
        this.wrappedInputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.wrappedInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.wrappedInputStream.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer.size() > 0) {
            int tot2Read = Math.min(this.buffer.size(), len);
            for (int i = 0; i < tot2Read; ++i) {
                b[i] = this.buffer.remove(0).byteValue();
                --this.contentLength;
            }
            return tot2Read;
        }
        int totRead = this.wrappedInputStream.read(b, off, len);
        this.contentLength -= totRead;
        return totRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrappedInputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.wrappedInputStream.skip(n);
    }

    public String toString() {
        return this.wrappedInputStream.toString();
    }

    public void resetBuffer() {
        this.buffer.clear();
    }

    public int wrappedAvailable() throws IOException {
        return this.wrappedInputStream.available();
    }
}

