/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.core;

import com.pangubpm.modules.form.core.BaseFormColumnConverter;
import com.pangubpm.modules.form.core.ClobConverter;
import com.pangubpm.modules.form.core.DateConverter;
import com.pangubpm.modules.form.core.NumberConverter;
import com.pangubpm.modules.form.core.VarCharConverter;
import com.pangubpm.modules.form.entity.FormBusinessEntity;
import com.pangubpm.modules.form.entity.FormBusinessModelColumnEntity;
import com.pangubpm.modules.form.entity.FormModelVO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FormTableConverter {
    protected static Map<String, BaseFormColumnConverter> convertersToBpmnMap = new HashMap<String, BaseFormColumnConverter>();

    public static void addConverter(BaseFormColumnConverter converter) {
        convertersToBpmnMap.put(converter.getXMLElementName(), converter);
    }

    public String convertElementToDDLScript(FormModelVO formModelVO) {
        List formColumnVOList = formModelVO.getFormBusinessModelColumnEntityList();
        StringBuffer stringBuffer = new StringBuffer();
        FormBusinessEntity formBusinessEntity = formModelVO.getFormBusinessEntity();
        String tableName = formBusinessEntity.getTableName();
        stringBuffer.append("create table ");
        stringBuffer.append(tableName);
        stringBuffer.append("(\n");
        for (int i = 0; i < formColumnVOList.size(); ++i) {
            FormBusinessModelColumnEntity fc = (FormBusinessModelColumnEntity)formColumnVOList.get(i);
            String s = convertersToBpmnMap.get(fc.getDataType()).convertElementToDDLScript(fc);
            stringBuffer.append(s);
            if (i >= formColumnVOList.size() - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("\n)");
        if (StringUtils.isNotEmpty((CharSequence)formBusinessEntity.getDescription())) {
            stringBuffer.append("COMMENT  '" + formBusinessEntity.getDescription() + " '");
            stringBuffer.append(" ");
        }
        stringBuffer.append(";");
        return stringBuffer.toString();
    }

    static {
        FormTableConverter.addConverter(new VarCharConverter());
        FormTableConverter.addConverter(new NumberConverter());
        FormTableConverter.addConverter(new DateConverter());
        FormTableConverter.addConverter(new ClobConverter());
    }
}

