/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.url.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.pangubpm.common.core.controller.BaseController;
import com.pangubpm.common.core.domain.AjaxResult;
import com.pangubpm.common.core.page.TableDataInfo;
import com.pangubpm.common.entity.Result;
import com.pangubpm.common.utils.Query;
import com.pangubpm.common.utils.StringUtil;
import com.pangubpm.modules.form.url.domain.BpmExternalUrl;
import com.pangubpm.modules.form.url.domain.BpmExternalUrlData;
import com.pangubpm.modules.form.url.service.IBpmExternalUrlDataService;
import com.pangubpm.modules.form.url.service.IBpmExternalUrlService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/system/url"})
public class BpmExternalUrlController
extends BaseController {
    @Autowired
    private IBpmExternalUrlService bpmExternalUrlService;
    @Autowired
    private IBpmExternalUrlDataService bpmExternalUrlDataService;

    @GetMapping(value={"/list"})
    public TableDataInfo list(BpmExternalUrl bpmExternalUrl, HttpServletRequest request) {
        Map params = this.getPageInfo(request);
        IPage page = new Query().getPage(params);
        IPage<BpmExternalUrl> tableDataInfoIPage = this.bpmExternalUrlService.selectBpmExternalUrlList((IPage<BpmExternalUrl>)page, bpmExternalUrl);
        return this.getDataTable(tableDataInfoIPage.getRecords(), tableDataInfoIPage.getTotal());
    }

    @GetMapping(value={"/list/code/{code}"})
    public TableDataInfo listByCode(@PathVariable(name="code") String code, HttpServletRequest request) {
        Map params = this.getPageInfo(request);
        IPage page = new Query().getPage(params);
        BpmExternalUrl bpmExternalUrl = new BpmExternalUrl();
        bpmExternalUrl.setCode(code);
        IPage<BpmExternalUrlData> tableDataInfoIPage = this.bpmExternalUrlDataService.selectBpmExternalUrlDataByMainCode((IPage<BpmExternalUrlData>)page, bpmExternalUrl);
        return this.getDataTable(tableDataInfoIPage.getRecords(), tableDataInfoIPage.getTotal());
    }

    @GetMapping(value={"/{id}"})
    public AjaxResult getInfo(@PathVariable(value="id") Long id) {
        return AjaxResult.success((Object)this.bpmExternalUrlService.selectBpmExternalUrlById(id));
    }

    @GetMapping(value={"/get/{formValue}"})
    public Result<BpmExternalUrl> getInfo(@PathVariable(value="formValue") String formValue) {
        BpmExternalUrl bpmExternalUrl = this.bpmExternalUrlService.selectBpmExternalUrlByCode(formValue);
        return new Result().success("\u67e5\u8be2\u6210\u529f").setResult((Object)bpmExternalUrl);
    }

    @PostMapping
    public AjaxResult add(@RequestBody BpmExternalUrl bpmExternalUrl) {
        return this.toAjax(this.bpmExternalUrlService.insertBpmExternalUrl(bpmExternalUrl));
    }

    @PostMapping(value={"/edit"})
    public AjaxResult edit(@RequestBody BpmExternalUrl bpmExternalUrl) {
        return this.toAjax(this.bpmExternalUrlService.updateBpmExternalUrl(bpmExternalUrl));
    }

    @DeleteMapping(value={"/{ids}"})
    public AjaxResult remove(@PathVariable Long[] ids) {
        return this.toAjax(this.bpmExternalUrlService.deleteBpmExternalUrlByIds(ids));
    }

    @GetMapping(value={"/remove/{ids}"})
    public AjaxResult remove(@PathVariable(value="ids", required=false) String ids) {
        if (StringUtil.isNotEmpty((String)ids)) {
            String[] tableIdStr = ids.split(",");
            Long[] idsLong = new Long[tableIdStr.length];
            for (int i = 0; i < tableIdStr.length; ++i) {
                String tableId = tableIdStr[i];
                idsLong[i] = Long.valueOf(tableId);
            }
            return this.toAjax(this.bpmExternalUrlService.deleteBpmExternalUrlByIds(idsLong));
        }
        return AjaxResult.success();
    }

    @GetMapping(value={"/selectBpmExternalUrlByCode/{formValue}"})
    public Result<BpmExternalUrl> selectBpmExternalUrlByCode(@PathVariable(value="formValue", required=false) String formValue) {
        BpmExternalUrl bpmExternalUrl = this.bpmExternalUrlService.selectBpmExternalUrlByCode(formValue);
        return new Result().success("\u67e5\u8be2\u6210\u529f").setResult((Object)bpmExternalUrl);
    }
}

