DROP TABLE IF EXISTS PANGU_BPM_EXTERNAL_URL;
CREATE TABLE PANGU_BPM_EXTERNAL_URL (
  ID BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
  NAME        VARCHAR(200)    DEFAULT ''                 COMMENT '名称',
  CODE     VARCHAR(500)    DEFAULT ''                 COMMENT '别名',
  STATUS            VARCHAR(1)      DEFAULT '1'              COMMENT '状态',
  LIST_URL            VARCHAR(500)  DEFAULT ''                  COMMENT '列表',
  ADD_URL            VARCHAR(500)  DEFAULT ''              COMMENT '添加',
  EDIT_URL            VARCHAR(500)  DEFAULT ''                  COMMENT '编辑',
  DETAIL_URL            VARCHAR(500)   DEFAULT ''                COMMENT '详情',
  PRIMARY KEY (ID)
) ENGINE=INNODB AUTO_INCREMENT=1 COMMENT = '外挂URL表单';

DROP TABLE IF EXISTS PANGU_BPM_EXTERNAL_URL_DATA;
CREATE TABLE PANGU_BPM_EXTERNAL_URL_DATA (
   ID BIGINT(20) NOT NULL AUTO_INCREMENT COMMENT '主键ID',
   NAME        VARCHAR(200)    DEFAULT ''                 COMMENT '名称',
   CODE     VARCHAR(500)    DEFAULT ''                 COMMENT '别名',
   STATUS            VARCHAR(1)    DEFAULT '1'               COMMENT '状态',
   BATCH_ID BIGINT(20) NOT NULL COMMENT '对应的父ID',
   PRIMARY KEY (`ID`)
)  COMMENT='外挂URL表单_数据';


DROP TABLE IF EXISTS OA_BECOME_REGULAR;
CREATE TABLE OA_BECOME_REGULAR (
   ID VARCHAR(64) NOT NULL  COMMENT '主键ID',
   ENTRY_TIME       DATETIME              COMMENT '入职时间',
   APPLY_USER_ID     VARCHAR(64)   COMMENT '申请人',
   REASON     VARCHAR(2000)   COMMENT '申请理由',
   JOB     VARCHAR(2000)   COMMENT '试用期职位',
   PROBATION     VARCHAR(2000)   COMMENT '试用期工作小结',
   PROCESS_ID     VARCHAR(40)   COMMENT '流程实例ID',
   PROCESS_TIME     DATETIME   COMMENT '流程发起时间',
   PROCESS_STATUS     VARCHAR(40)   COMMENT '流程状态',
   BIZ_KEY     VARCHAR(40)   COMMENT '业务键',
   PRIMARY KEY (`ID`)
)  COMMENT='员工转正申请表';


DROP TABLE IF EXISTS OA_DESIGN_FORM;
CREATE TABLE OA_DESIGN_FORM (
   ID VARCHAR(64) NOT NULL  COMMENT '主键ID',
   DES_FORM_NAME     VARCHAR(64)   COMMENT '名称',
   DES_FORM_ICON     VARCHAR(200)   COMMENT '图标',
    APP_ICON     VARCHAR(200)   COMMENT 'APP图标',
   DES_FORM_CODE     VARCHAR(200)   COMMENT '编码',
   PROC_NAME     VARCHAR(200)   COMMENT '流程名称',
   PROC_KEY     VARCHAR(200)   COMMENT '流程Key',
   PROC_TYPE     VARCHAR(40)    COMMENT '类型',
   PRIMARY KEY (ID)
)  COMMENT='OA工单申请';
DROP TABLE IF EXISTS OA_DIMISSION;
CREATE TABLE OA_DIMISSION (
   ID VARCHAR(64) NOT NULL  COMMENT '主键ID',
   CREATE_BY     VARCHAR(64)   COMMENT '创建用户',
   CREATE_TIME     TIMESTAMP   COMMENT '创建日期',
   DIMISSION_NO     VARCHAR(200)   COMMENT '离职人',
   HANDOVER_CONTENT     VARCHAR(200)   COMMENT '离职内容',
   HANDOVER_DATE     TIMESTAMP   COMMENT '离职日期',
   SAY_QUIT_DATE     TIMESTAMP   COMMENT '提出辞职时间',
   HANDOVER_RECEIVER     VARCHAR(200)   COMMENT '移交人',
   IS_PROBATION     VARCHAR(200)   COMMENT '是否在试用期',
   REASON     VARCHAR(200)   COMMENT '原因',
      BIZ_KEY     VARCHAR(40)   COMMENT '业务键',
   PRIMARY KEY (ID)
)  COMMENT='OA离职申请';


INSERT INTO `sys_menu` VALUES (21007, 2100, '外挂表单', '/bpm/url/index', NULL, 1, 'fa fa-rocket', 4, 0, 3, '/bpm/url/index', '@/views/bpm/url/index', 'wgbd', 1, 0);
INSERT INTO `sys_menu` VALUES (3119002, 3010, '工单管理', '/extbpm/form/index', NULL, 1, 'fa fa-rocket', 11, 0, 3, '/extbpm/form/index', '@/views/extbpm/form/index', 'FormIndex', 1, 0);
INSERT INTO `sys_menu` VALUES (3119003, 3010, '工单申请', '/extbpm/process/BpmAutoDesformApply', NULL, 1, 'fa fa-rocket', 12, 0, 3, '/extbpm/process/BpmAutoDesformApply', '@/views/extbpm/process/BpmAutoDesformApply', 'BpmAutoDesformApply', 1, 0);
INSERT INTO `sys_menu` VALUES (3109, 3100, '首页', '/bpm/index', NULL, 1, 'fa fa-rocket', 9, 0, 3, '/bpm/index', '@/views/bpm/index', 'bpmIndex', 1, 0);

