/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.resource;

import com.pangu.form.api.FormDefinition;
import com.pangu.form.api.FormInstance;
import com.pangu.form.api.FormInstanceQuery;
import com.pangu.form.api.FormRepositoryService;
import com.pangu.form.api.FormService;
import com.pangu.form.engine.FormEngineConfiguration;
import com.pangubpm.common.annotation.SysLog;
import com.pangubpm.common.utils.IoUtil;
import com.pangubpm.common.utils.Result;
import com.pangubpm.common.web.AbstractController;
import com.pangubpm.editor.form.FormJsonConverter;
import com.pangubpm.form.model.original.FormOriginalModel;
import com.pangubpm.form.model.original.SimpleOriginalFormModel;
import com.pangubpm.modules.form.service.FormBusObjectService;
import com.pangubpm.modules.form.utils.FormParser;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/form/bus/render/"})
public class FormRenderController
extends AbstractController {
    private static FormJsonConverter formJsonConverter = new FormJsonConverter();
    @Autowired
    private FormService formService;
    @Autowired
    private FormEngineConfiguration formEngineConfiguration;
    @Autowired
    private FormBusObjectService formBusObjectService;

    @GetMapping(value={"/get/{taskId}"})
    @SysLog(value="\u67e5\u8be2\u4e1a\u52a1\u8868\u5355")
    @ResponseBody
    public Result businessTableList(HttpServletRequest request, @PathVariable(value="taskId") String taskId, @RequestParam(value="processInstanceId", required=false) String processInstanceId) {
        String userId = this.getUserId(request);
        return this.formBusObjectService.getUserTaskTemplateHtml(taskId, processInstanceId, userId);
    }

    @GetMapping(value={"/get/renderHisForm/{historicTaskInstanceId}"})
    @SysLog(value="\u67e5\u8be2\u5386\u53f2\u6e32\u67d3\u4e1a\u52a1\u8868\u5355")
    @ResponseBody
    public Result businessTableList(@PathVariable(value="historicTaskInstanceId") String historicTaskInstanceId) throws UnsupportedEncodingException {
        List formInstances = ((FormInstanceQuery)this.formService.createFormInstanceQuery().processInstanceId(historicTaskInstanceId).orderBySubmittedDate().desc()).list();
        String result = "";
        String resultFormData = "";
        if (formInstances.size() > 0) {
            String formValue;
            FormInstance formInstance = (FormInstance)formInstances.get(0);
            FormRepositoryService formRepositoryService = this.formEngineConfiguration.getFormRepositoryService();
            resultFormData = formValue = formRepositoryService.getDeploymentResourceById(formInstance.getFormValuesId());
            String formDefinitionId = formInstance.getFormDefinitionId();
            Map<String, Object> variables = FormParser.readTreeHandler(formValue);
            FormDefinition formDefinition = (FormDefinition)formRepositoryService.createFormDefinitionQuery().formId(formDefinitionId).singleResult();
            String deploymentId = formDefinition.getDeploymentId();
            InputStream inputStream = formRepositoryService.getResourceAsStream(deploymentId, formDefinition.getResourceName());
            byte[] bytes = IoUtil.readInputStream((InputStream)inputStream, (String)formDefinition.getResourceName());
            String formTempleteStr = new String(bytes, "UTF-8");
            SimpleOriginalFormModel formOriginalModel = (SimpleOriginalFormModel)formJsonConverter.convertToFormModel(formTempleteStr, true);
            List list = formOriginalModel.getList();
            formOriginalModel.setList(list);
            result = formJsonConverter.convertToJson((FormOriginalModel)formOriginalModel);
        }
        return Result.ok().put("data", (Object)result).put("editData", (Object)resultFormData);
    }

    @GetMapping(value={"start/get/renderForm/{id}"})
    @SysLog(value="\u67e5\u8be2\u53ef\u542f\u52a8\u7684\u4e1a\u52a1\u8868\u5355")
    @ResponseBody
    public Result startForm(HttpServletRequest request, @PathVariable(value="id") String id) {
        if (StringUtils.isEmpty((CharSequence)id) && !id.equals("undefined")) {
            return Result.error((String)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.formBusObjectService.getTemplateHtml(id, this.getUserNo(request));
    }

    @GetMapping(value={"start/get/{id}"})
    @SysLog(value="\u67e5\u8be2\u53ef\u542f\u52a8\u7684\u4e1a\u52a1\u8868\u5355")
    @ResponseBody
    public Result renderForm(@PathVariable(value="id") String id) {
        if (StringUtils.isEmpty((CharSequence)id) || id.equals("undefined")) {
            return Result.error((String)"\u8868\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.formBusObjectService.getTemplateJson(id);
    }

    @RequestMapping(value={"getStruct/{id}"})
    @ResponseBody
    public Result getBoStruct(HttpServletRequest request, @PathVariable(required=true, name="id") String id) {
        return this.formBusObjectService.getBoTypeStruct(id);
    }
}

