/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FormParser {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static Map<String, Object> readTree(JsonNode valuesNode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator fieldIdIterator = valuesNode.fieldNames();
        while (fieldIdIterator.hasNext()) {
            String fieldId = (String)fieldIdIterator.next();
            JsonNode asTex = valuesNode.get(fieldId);
            JsonNodeType nodeType = valuesNode.getNodeType();
            if (asTex.isArray()) {
                int size = asTex.size();
                HashMap innerMap = new HashMap(size);
                JSONArray jsonArray = new JSONArray();
                for (JsonNode objNode : asTex) {
                    Iterator stringIterator = objNode.fieldNames();
                    JSONObject innerJsonObject = new JSONObject();
                    while (stringIterator.hasNext()) {
                        String fieldId1 = (String)stringIterator.next();
                        JsonNode jsonNode = objNode.get(fieldId1);
                        innerJsonObject.put(fieldId1, (Object)jsonNode.asText());
                    }
                    jsonArray.add((Object)innerJsonObject);
                }
                map.put(fieldId, jsonArray);
                continue;
            }
            map.put(fieldId, asTex.asText());
        }
        return map;
    }

    public static Map<String, Object> readTreeHandler(String formValue) {
        try {
            JsonNode submittedNode = objectMapper.readTree(formValue);
            if (submittedNode != null && submittedNode.get("values") != null) {
                JsonNode valuesNode = submittedNode.get("values");
                Map result = (Map)objectMapper.convertValue((Object)valuesNode, Map.class);
                return result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Map<String, Object> readTreeBeansHandler(String formValue) {
        try {
            JsonNode submittedNode = objectMapper.readTree(formValue);
            if (submittedNode.get("beans") != null) {
                JsonNode valuesNode = submittedNode.get("beans");
                Map<String, Object> map = FormParser.readTree(valuesNode);
                return map;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

