/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.resource;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.pangubpm.common.annotation.SysLog;
import com.pangubpm.common.config.PanguProperties;
import com.pangubpm.common.utils.Query;
import com.pangubpm.common.utils.Result;
import com.pangubpm.common.web.AbstractController;
import com.pangubpm.modules.form.constant.PanGuColumnType;
import com.pangubpm.modules.form.entity.FormBusinessEntity;
import com.pangubpm.modules.form.entity.FormBusinessModelColumnEntity;
import com.pangubpm.modules.form.entity.FormModelVO;
import com.pangubpm.modules.form.entity.TableColumnMetaDataEntity;
import com.pangubpm.modules.form.entity.TableMetaDataEntity;
import com.pangubpm.modules.form.query.FormBusinessQuery;
import com.pangubpm.modules.form.service.FormBusinessService;
import com.pangubpm.modules.form.service.MetadataService;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/form/bus/businessTable/"})
public class BusinessTableController
extends AbstractController {
    @Autowired
    private PanguProperties panguProperties;
    @Autowired
    private FormBusinessService formBusinessService;
    @Autowired
    private MetadataService metadataService;
    @Value(value="${pangu.desensitization:true}")
    private Boolean desensitization;

    @GetMapping(value={"businessTableList"})
    public String businessTableList() throws UnsupportedEncodingException {
        return "modules/form/businessTableList";
    }

    @GetMapping(value={"businessTableEdit"})
    public String businessTableEdit() throws UnsupportedEncodingException {
        return "modules/form/businessTableEdit";
    }

    @RequestMapping(value={"/listJson"})
    @ResponseBody
    @SysLog(value="\u67e5\u8be2\u4e1a\u52a1\u5b9e\u4f53")
    public Result listJson(@ApiIgnore @RequestParam Map<String, Object> allRequestParams, FormBusinessQuery formBusinessQuery) {
        IPage page = new Query().getPage(allRequestParams);
        String tenantId = this.getTenantId();
        Result r = this.formBusinessService.listByGroupId((IPage<FormBusinessEntity>)page, allRequestParams, formBusinessQuery, tenantId);
        return r;
    }

    @PostMapping(value={"doDbSynch/{id}"})
    @SysLog(value="\u540c\u6b65\u8868")
    @ResponseBody
    public Result doDbSynch(@PathVariable(name="id") String id, HttpServletRequest request) {
        String userId = this.getUserId(request);
        String tenantId = this.getTenantId();
        return this.formBusinessService.doDbSynch(id);
    }

    @PostMapping(value={"/save"})
    @SysLog(value="\u4fdd\u5b58\u4e1a\u52a1\u5b9e\u4f53")
    @ResponseBody
    public Result saveOrUpdate(HttpServletRequest request, @RequestBody(required=false) FormModelVO formModelVO) {
        String userId = this.getUserId(request);
        String tenantId = this.getTenantId();
        return this.formBusinessService.saveOrUpdate(formModelVO, userId, tenantId);
    }

    @GetMapping(value={"/delete/{tableId}"})
    @SysLog(value="\u5220\u9664\u4e1a\u52a1\u5b9e\u4f53")
    @ResponseBody
    public Result delete(@PathVariable(required=false, name="tableId") String tableId) {
        if (Boolean.valueOf(this.panguProperties.getDelete()).booleanValue()) {
            return this.formBusinessService.delete(tableId);
        }
        return Result.error((String)"\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
    }

    @GetMapping(value={"/metadataInfo"})
    @SysLog(value="\u67e5\u8be2\u4e1a\u52a1\u5b9e\u4f53\u5143\u6570\u636e\u4fe1\u606f")
    @ResponseBody
    public Result saveOrUpdate() {
        String tenantId = this.getTenantId();
        List<TableMetaDataEntity> stringStringMap = this.metadataService.queryAllTable(null, tenantId);
        List<Object> result = new ArrayList();
        if (this.desensitization.booleanValue()) {
            for (TableMetaDataEntity tmde : stringStringMap) {
                if (tmde.getTableName().startsWith("A1_") || tmde.getTableName().startsWith("act") || tmde.getTableName().startsWith("PANGU") || tmde.getTableName().startsWith("DATABASE") || tmde.getTableName().startsWith("FLW_") || tmde.getTableName().startsWith("QRTZ_") || tmde.getTableName().startsWith("pangu_") || tmde.getTableName().startsWith("sys_") || tmde.getTableName().startsWith("approval") || tmde.getTableName().startsWith("schedule_")) continue;
                result.add(tmde);
            }
        } else {
            result = stringStringMap;
        }
        return Result.ok().put("data", result);
    }

    @GetMapping(value={"/metadataInfo/{tableName}"})
    @SysLog(value="\u67e5\u8be2\u4e1a\u52a1\u5b9e\u4f53\u8868\u5143\u6570\u636e\u4fe1\u606f")
    @ResponseBody
    public Result queryColumnByTableNames(@PathVariable(required=false, name="tableName") String tableName) {
        String tenantId = this.getTenantId();
        List<TableColumnMetaDataEntity> stringStringMap = this.metadataService.queryColumnByTableName(tableName, tenantId);
        List<FormBusinessModelColumnEntity> formBusinessModelColumnEntities = this.converTableColumnMetaDataEntityToFormBusinessModelColumnEntity(stringStringMap);
        return Result.ok().put("data", formBusinessModelColumnEntities);
    }

    private List<FormBusinessModelColumnEntity> converTableColumnMetaDataEntityToFormBusinessModelColumnEntity(List<TableColumnMetaDataEntity> tableColumnMetaDataEntities) {
        ArrayList<FormBusinessModelColumnEntity> formBusinessModelColumnEntityList = new ArrayList<FormBusinessModelColumnEntity>();
        for (TableColumnMetaDataEntity tcmd : tableColumnMetaDataEntities) {
            FormBusinessModelColumnEntity formBusinessModelColumnEntity = new FormBusinessModelColumnEntity();
            PanGuColumnType byDbDataType = PanGuColumnType.getByDbDataType((String)tcmd.getDataType());
            formBusinessModelColumnEntity.setDataType(byDbDataType.getKey());
            formBusinessModelColumnEntity.setDescription(StringUtils.isNotEmpty((CharSequence)tcmd.getColumnComment()) ? tcmd.getColumnComment() : tcmd.getColumnName());
            formBusinessModelColumnEntity.setName(tcmd.getColumnName());
            formBusinessModelColumnEntity.setAttrLength(tcmd.getAttrLength());
            formBusinessModelColumnEntity.setColumnKey(tcmd.getColumnKey());
            formBusinessModelColumnEntity.setDecimalLength(tcmd.getDecimalLength());
            formBusinessModelColumnEntityList.add(formBusinessModelColumnEntity);
        }
        return formBusinessModelColumnEntityList;
    }

    @GetMapping(value={"/get/{id}"})
    @ResponseBody
    public Result get(@PathVariable(required=true, name="id") String id) {
        return this.formBusinessService.getTableAndColumn(id);
    }

    @GetMapping(value={"/form/List"})
    @ResponseBody
    public Result listBtns() {
        Result r = Result.ok();
        return r.put("data", (Object)PanGuColumnType.toJson());
    }

    @GetMapping(value={"createTable/{tableId}"})
    @ResponseBody
    public Result createTable(@PathVariable(value="tableId") String tableId) throws Exception {
        return Result.error((String)"4.x\u7248\u672c\u4e0d\u518d\u652f\u6301\u751f\u6210\u8868");
    }

    @GetMapping(value={"column/delete/{id}"})
    @ResponseBody
    public Result columnDelete(@PathVariable(value="id") String id) {
        return this.formBusinessService.deleteColumnById(id);
    }
}

