/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.core;

import com.pangubpm.modules.form.core.BaseFormColumnConverter;
import com.pangubpm.modules.form.entity.FormBusinessModelColumnEntity;
import org.apache.commons.lang3.StringUtils;

public class VarCharConverter
extends BaseFormColumnConverter {
    @Override
    protected String getXMLElementName() {
        return "varchar";
    }

    @Override
    protected boolean isSupport(FormBusinessModelColumnEntity formColumnVO) {
        return formColumnVO.getDataType().equals("varchar");
    }

    @Override
    protected String doConvertElementToDDLScript(FormBusinessModelColumnEntity formColumnVO) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(formColumnVO.getName());
        stringBuffer.append(" ");
        stringBuffer.append(this.getXMLElementName());
        stringBuffer.append("(");
        stringBuffer.append(formColumnVO.getAttrLength());
        stringBuffer.append(")");
        stringBuffer.append(" ");
        if (formColumnVO.isRequired()) {
            stringBuffer.append("not  null");
            stringBuffer.append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)formColumnVO.getDefaultValue())) {
            stringBuffer.append("DEFAULT  " + formColumnVO.getDefaultValue());
            stringBuffer.append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)formColumnVO.getDescription())) {
            stringBuffer.append("COMMENT  '" + formColumnVO.getDescription() + " '");
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

