/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.resource;

import com.pangubpm.common.annotation.SysLog;
import com.pangubpm.common.config.PanguProperties;
import com.pangubpm.common.utils.Result;
import com.pangubpm.common.utils.SnowflakeIdWorkerUtils;
import com.pangubpm.common.web.AbstractController;
import com.pangubpm.modules.form.entity.FormCustomQueryWithBLOBs;
import com.pangubpm.modules.form.service.FormCustomQueryService;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/form/customQuery/"})
public class FormCustomQueryController
extends AbstractController {
    @Autowired
    private PanguProperties panguProperties;
    @Autowired
    private FormCustomQueryService formCustomQueryService;

    @GetMapping(value={"list"})
    public String list() throws Exception {
        return "modules/form/customQueryList";
    }

    @GetMapping(value={"detail"})
    public String customQueryDetail(Model model, @RequestParam @ApiIgnore Map<String, Object> allRequestParams) throws Exception {
        Object id = allRequestParams.get("id");
        if (id != null && StringUtils.isNotEmpty((CharSequence)id.toString())) {
            model.addAttribute("id", (Object)id.toString());
        }
        return "modules/form/customQueryDetail";
    }

    @GetMapping(value={"listJson"})
    @ResponseBody
    public Result listJson(@ApiIgnore @RequestParam Map<String, Object> params) {
        return this.formCustomQueryService.queryPage(params);
    }

    @GetMapping(value={"/data"})
    public String tableEditBak() {
        return "modules/form/dataEdit";
    }

    @GetMapping(value={"/get/{id}"})
    @ResponseBody
    public Result get(@PathVariable String id) {
        return this.formCustomQueryService.getById(id);
    }

    @PostMapping(value={"save"})
    @SysLog(value="\u4fdd\u5b58\u8868\u5355\u81ea\u5b9a\u4e49\u67e5\u8be2")
    @ResponseBody
    public Result save(HttpServletRequest request, FormCustomQueryWithBLOBs formCustomQueryWithBLOBs) throws Exception {
        String id = formCustomQueryWithBLOBs.getId();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            this.formCustomQueryService.updateById(formCustomQueryWithBLOBs);
        } else {
            id = SnowflakeIdWorkerUtils.getNextId();
            formCustomQueryWithBLOBs.setId(id);
            String userId = this.getUserId(request);
            this.formCustomQueryService.saveAndCeateJson(userId, formCustomQueryWithBLOBs);
        }
        return Result.ok();
    }

    @PostMapping(value={"/delete"})
    @ResponseBody
    public Result delete(@RequestParam(value="ids[]") String[] ids) {
        Result r = Result.ok();
        if (!Boolean.valueOf(this.panguProperties.getDelete()).booleanValue()) {
            return Result.error((String)"\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        this.formCustomQueryService.removeByIds(Arrays.asList(ids));
        return r;
    }

    @RequestMapping(value={"manger/{key}"})
    @ResponseBody
    public Result customerQuery(@PathVariable String key) {
        Result r = Result.ok();
        return this.formCustomQueryService.customerQueryByKey(key);
    }

    @RequestMapping(value={"get/key/{key}"})
    @ResponseBody
    public Result getByKey(@PathVariable String key) {
        Result r = Result.ok();
        return this.formCustomQueryService.getByKey(key);
    }
}

