/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.resource;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pangu.form.api.FormDeployment;
import com.pangu.form.api.FormInfo;
import com.pangu.form.api.FormInstance;
import com.pangu.form.api.FormRepositoryService;
import com.pangu.form.api.FormService;
import com.pangu.form.engine.FormEngineConfiguration;
import com.pangubpm.common.entity.Result;
import com.pangubpm.common.web.AbstractController;
import com.pangubpm.modules.form.entity.FormDefinitionEntity;
import com.pangubpm.modules.form.model.FormDefinition;
import com.pangubpm.modules.form.service.FormBusinessService;
import com.pangubpm.modules.form.service.FormDesignService;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/form/fact"})
@Controller
public class FormFactResource
extends AbstractController {
    ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private FormService formService;
    @Autowired
    private FormBusinessService formBusinessService;
    @Autowired
    private FormDesignService formDesignService;
    @Autowired
    private FormEngineConfiguration formEngineConfiguration;

    @PostMapping(value={"/deployForm"})
    @ResponseBody
    public Result<Boolean> deployForm(@RequestParam(value="formValue", required=false) String formValue, @RequestParam(value="type", required=false) String type, @RequestParam(value="id", required=false) String id, @RequestParam(value="formJsonStr", required=false) String formJsonStr) {
        boolean isOk = this.formDesignService.deployForm(formValue, type, id, formJsonStr);
        return new Result().success("\u67e5\u8be2\u6210\u529f").setResult((Object)isOk);
    }

    @PostMapping(value={"/createFormInstance"})
    @ResponseBody
    public Result<Boolean> createFormInstance(@RequestParam(value="variablesStr", required=false) String variablesStr, @RequestParam(value="formInfoStr", required=false) String formInfoStr, @RequestParam(value="taskId", required=false) String taskId, @RequestParam(value="processInstanceId", required=false) String processInstanceId, @RequestParam(value="processDefinitionId", required=false) String processDefinitionId, @RequestParam(value="tenantId", required=false) String tenantId, @RequestParam(value="outcome", required=false) String outcome) {
        FormInfo formInfo = (FormInfo)JSON.parseObject((String)formInfoStr, FormInfo.class);
        Map variables = (Map)JSON.parseObject((String)variablesStr, Map.class);
        FormInstance formInstance = this.formService.createFormInstance(variables, formInfo, taskId, processInstanceId, processDefinitionId, tenantId, outcome);
        return new Result().success("\u67e5\u8be2\u6210\u529f").setResult((Object)(formInstance != null ? 1 : 0));
    }

    @PostMapping(value={"/saveFormInstance"})
    @ResponseBody
    public Result<Boolean> saveFormInstance(@RequestParam(value="variablesStr", required=false) String variablesStr, @RequestParam(value="formInfoStr", required=false) String formInfoStr, @RequestParam(value="taskId", required=false) String taskId, @RequestParam(value="processInstanceId", required=false) String processInstanceId, @RequestParam(value="processDefinitionId", required=false) String processDefinitionId, @RequestParam(value="tenantId", required=false) String tenantId, @RequestParam(value="outcome", required=false) String outcome) {
        FormInfo formInfo = (FormInfo)JSON.parseObject((String)formInfoStr, FormInfo.class);
        Map variables = (Map)JSON.parseObject((String)variablesStr, Map.class);
        FormInstance formInstance = this.formService.saveFormInstance(variables, formInfo, taskId, processInstanceId, processDefinitionId, tenantId, outcome);
        return new Result().success("\u67e5\u8be2\u6210\u529f").setResult((Object)(formInstance != null ? 1 : 0));
    }

    @PostMapping(value={"/getFormDefinitionByDeploymentId"})
    @ResponseBody
    public Result<FormDefinitionEntity> getFormDefinitionByDeploymentId(@RequestParam(value="formDeploymentId") String formDeploymentId) {
        FormRepositoryService formRepositoryService = this.formEngineConfiguration.getFormRepositoryService();
        FormDeployment formDeployment = (FormDeployment)formRepositoryService.createDeploymentQuery().parentDeploymentId(formDeploymentId).singleResult();
        String formDeploymentIdChild = formDeployment.getId();
        com.pangu.form.api.FormDefinition formDefinition = (com.pangu.form.api.FormDefinition)formRepositoryService.createFormDefinitionQuery().deploymentId(formDeploymentIdChild).singleResult();
        FormDefinitionEntity formDefinitionEntity = new FormDefinitionEntity();
        formDefinitionEntity.setId(formDefinition.getId());
        formDefinitionEntity.setCategory(formDefinition.getCategory());
        formDefinitionEntity.setDeploymentId(formDefinition.getDeploymentId());
        formDefinitionEntity.setKey(formDefinition.getKey());
        formDefinitionEntity.setTenantId(formDefinition.getTenantId());
        return new Result().success("\u67e5\u8be2\u6210\u529f").setResult((Object)formDefinitionEntity);
    }

    @PostMapping(value={"/handlerPhysicalTable"})
    @ResponseBody
    public Result<Boolean> handlerPhysicalTable(@RequestParam(value="tableKey", required=false) String tableKey, @RequestParam(value="formKey", required=false) String formKey, @RequestParam(value="jsonNodeStr", required=false) String jsonNodeStr, @RequestParam(value="businessKey", required=false) String businessKey, @RequestParam(value="formValue", required=false) boolean isSave) {
        return this.formBusinessService.handlerPhysicalTable(tableKey, formKey, jsonNodeStr, businessKey, isSave);
    }

    @PostMapping(value={"/getByMainKey"})
    @ResponseBody
    public Result<FormDefinition> getByMainKeyForm(@RequestParam(value="formValue", required=false) String formValue) {
        FormDefinition formDefinition = this.formDesignService.getByMainKey(formValue);
        return new Result().success("\u67e5\u8be2\u6210\u529f").setResult((Object)formDefinition);
    }
}

