/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.core;

import com.pangubpm.modules.form.core.BaseFormColumnConverter;
import com.pangubpm.modules.form.entity.FormBusinessModelColumnEntity;
import org.apache.commons.lang3.StringUtils;

public class DateConverter
extends BaseFormColumnConverter {
    @Override
    protected String getXMLElementName() {
        return "date";
    }

    @Override
    protected boolean isSupport(FormBusinessModelColumnEntity formColumnVO) {
        return formColumnVO.getDataType().equals("date");
    }

    @Override
    protected String doConvertElementToDDLScript(FormBusinessModelColumnEntity formColumnVO) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(formColumnVO.getName());
        stringBuffer.append(" ");
        this.getType(formColumnVO, stringBuffer);
        if (formColumnVO.isRequired()) {
            stringBuffer.append("not  null");
            stringBuffer.append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)formColumnVO.getDefaultValue())) {
            stringBuffer.append("DEFAULT  " + formColumnVO.getDefaultValue());
            stringBuffer.append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)formColumnVO.getDescription())) {
            stringBuffer.append("COMMENT  '" + formColumnVO.getDescription() + " '");
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void getType(FormBusinessModelColumnEntity formColumnVO, StringBuffer stringBuffer) {
        String format = formColumnVO.getFormat();
        if (StringUtils.isNotEmpty((CharSequence)format)) {
            if (format.equals("yyyy-MM-dd")) {
                stringBuffer.append("date ");
            } else if (format.equals("yyyy-MM-dd HH:mm:ss")) {
                stringBuffer.append("datetime ");
            } else if (format.equals("HH:mm:ss")) {
                stringBuffer.append("time ");
            }
        } else {
            stringBuffer.append("datetime ");
        }
    }
}

