/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.core;

import com.pangubpm.modules.form.core.BaseFormColumnConverter;
import com.pangubpm.modules.form.entity.FormBusinessModelColumnEntity;
import org.apache.commons.lang3.StringUtils;

public class NumberConverter
extends BaseFormColumnConverter {
    @Override
    protected String getXMLElementName() {
        return "number";
    }

    @Override
    protected boolean isSupport(FormBusinessModelColumnEntity formColumnVO) {
        return formColumnVO.getDataType().equals("number");
    }

    @Override
    protected String doConvertElementToDDLScript(FormBusinessModelColumnEntity formColumnVO) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(formColumnVO.getName());
        stringBuffer.append(" ");
        this.getType(formColumnVO, stringBuffer);
        if (formColumnVO.isRequired()) {
            stringBuffer.append("not  null");
            stringBuffer.append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)formColumnVO.getDefaultValue())) {
            stringBuffer.append("DEFAULT  " + formColumnVO.getDefaultValue());
            stringBuffer.append(" ");
        }
        if (StringUtils.isNotEmpty((CharSequence)formColumnVO.getDescription())) {
            stringBuffer.append("COMMENT  '" + formColumnVO.getDescription() + " '");
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void getType(FormBusinessModelColumnEntity formColumnVO, StringBuffer stringBuffer) {
        stringBuffer.append("INT ");
    }
}

