/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.db.service.impl;

import com.pangubpm.common.db.operate.DbTypeOperate;
import com.pangubpm.common.utils.BpmSpringContextUtils;
import com.pangubpm.modules.db.entity.ColumnMeta;
import com.pangubpm.modules.db.entity.FormDataBaseConfig;
import com.pangubpm.modules.db.service.DbTableHandle;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class MysqlHandleImpl
implements DbTableHandle {
    @Override
    public String getAddColumnSql(ColumnMeta columnMeta) {
        return " ADD COLUMN " + this.getAddFieldDesc(columnMeta) + ";";
    }

    @Override
    public String getReNameFieldName(ColumnMeta columnMeta) {
        return "CHANGE COLUMN " + columnMeta.getOldColumnName() + " " + this.getRenameFieldDesc(columnMeta) + " ;";
    }

    @Override
    public String getUpdateColumnSql(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) {
        return " MODIFY COLUMN " + this.getUpdateFieldDesc(cgformcolumnMeta, datacolumnMeta) + ";";
    }

    @Override
    public String getMatchClassTypeByDataType(String dataType, int digits) {
        String result = "";
        if ("varchar".equalsIgnoreCase(dataType)) {
            result = "string";
        } else if ("double".equalsIgnoreCase(dataType)) {
            result = "double";
        } else if ("int".equalsIgnoreCase(dataType)) {
            result = "int";
        } else if ("Date".equalsIgnoreCase(dataType)) {
            result = "date";
        } else if ("Datetime".equalsIgnoreCase(dataType)) {
            result = "date";
        } else if ("decimal".equalsIgnoreCase(dataType)) {
            result = "bigdecimal";
        } else if ("text".equalsIgnoreCase(dataType)) {
            result = "text";
        } else if ("blob".equalsIgnoreCase(dataType)) {
            result = "blob";
        }
        return result;
    }

    @Override
    public String dropTableSQL(String tableName) {
        return " DROP TABLE IF EXISTS " + tableName + " ;";
    }

    @Override
    public Boolean judgeTableIsExit(String tableName) {
        Boolean bl;
        Connection conn = null;
        ResultSet rs = null;
        try {
            String[] types = new String[]{"TABLE"};
            conn = DbTypeOperate.getDataSource().getConnection();
            DatabaseMetaData dbMetaData = conn.getMetaData();
            String dataBaseType = null;
            dataBaseType = DbTypeOperate.getDatabaseType();
            String tableNamePattern = DbTypeOperate.getTableName((String)tableName, (String)dataBaseType);
            FormDataBaseConfig dataBaseConfig = (FormDataBaseConfig)BpmSpringContextUtils.getApplicationContext().getBean(FormDataBaseConfig.class);
            String user = dataBaseConfig.getUsername();
            if ("ORACLE".equals(dataBaseType)) {
                user = user.toUpperCase();
            }
            rs = dbMetaData.getTables(conn.getCatalog(), user, tableNamePattern, types);
            rs = "SQLSERVER".equals(dataBaseType) ? dbMetaData.getTables(conn.getCatalog(), null, tableNamePattern, types) : dbMetaData.getTables(conn.getCatalog(), user, tableNamePattern, types);
            if (rs.next()) {
                Boolean bl2 = true;
                return bl2;
            }
            bl = false;
        }
        catch (SQLException e) {
            throw new RuntimeException();
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return bl;
    }

    @Override
    public String getDropColumnSql(String fieldName) {
        return " DROP COLUMN " + fieldName + ";";
    }

    private String getFieldDesc(ColumnMeta cgfromcolumnMeta, ColumnMeta datacolumnMeta) {
        String result = "";
        String javaType = cgfromcolumnMeta.getJavaType();
        String columnName = cgfromcolumnMeta.getColumnName();
        if ("string".equalsIgnoreCase(javaType)) {
            result = columnName + " varchar(" + cgfromcolumnMeta.getColumnSize() + ") " + ("Y".equals(cgfromcolumnMeta.getIsNullable()) ? "NULL" : "NOT NULL");
        } else if ("date".equalsIgnoreCase(javaType)) {
            result = columnName + " datetime " + ("Y".equals(cgfromcolumnMeta.getIsNullable()) ? "NULL" : "NOT NULL");
        } else if ("int".equalsIgnoreCase(javaType)) {
            result = columnName + " int(" + cgfromcolumnMeta.getColumnSize() + ") " + ("Y".equals(cgfromcolumnMeta.getIsNullable()) ? "NULL" : "NOT NULL");
        } else if ("double".equalsIgnoreCase(javaType)) {
            result = columnName + " double(" + cgfromcolumnMeta.getColumnSize() + "," + cgfromcolumnMeta.getDecimalDigits() + ") " + ("Y".equals(cgfromcolumnMeta.getIsNullable()) ? "NULL" : "NOT NULL");
        } else if ("bigdecimal".equalsIgnoreCase(javaType)) {
            result = columnName + " decimal(" + cgfromcolumnMeta.getColumnSize() + "," + cgfromcolumnMeta.getDecimalDigits() + ") " + ("Y".equals(cgfromcolumnMeta.getIsNullable()) ? "NULL" : "NOT NULL");
        } else if ("text".equalsIgnoreCase(javaType)) {
            result = columnName + " text " + ("Y".equals(cgfromcolumnMeta.getIsNullable()) ? "NULL" : "NOT NULL");
        } else if ("blob".equalsIgnoreCase(javaType)) {
            result = columnName + " blob " + ("Y".equals(cgfromcolumnMeta.getIsNullable()) ? "NULL" : "NOT NULL");
        } else if ("json".equalsIgnoreCase(javaType)) {
            result = columnName + " json " + ("Y".equals(cgfromcolumnMeta.getIsNullable()) ? "NULL" : "NOT NULL");
        } else if ("tinyint".equalsIgnoreCase(javaType)) {
            result = columnName + " tinyint(" + cgfromcolumnMeta.getColumnSize() + ") " + ("Y".equals(cgfromcolumnMeta.getIsNullable()) ? "NULL" : "NOT NULL");
        } else if ("bigint".equalsIgnoreCase(javaType)) {
            result = columnName + " bigint(" + cgfromcolumnMeta.getColumnSize() + ") " + ("Y".equals(cgfromcolumnMeta.getIsNullable()) ? "NULL" : "NOT NULL");
        }
        result = result + (StringUtils.isNotEmpty((CharSequence)cgfromcolumnMeta.getComment()) ? " COMMENT '" + cgfromcolumnMeta.getComment() + "'" : " ");
        result = result + (StringUtils.isNotEmpty((CharSequence)cgfromcolumnMeta.getFieldDefault()) ? " DEFAULT " + cgfromcolumnMeta.getFieldDefault() : " ");
        String pkType = cgfromcolumnMeta.getPkType();
        if ("id".equalsIgnoreCase(cgfromcolumnMeta.getColumnName()) && pkType != null && ("SEQUENCE".equalsIgnoreCase(pkType) || "NATIVE".equalsIgnoreCase(pkType))) {
            result = result + " AUTO_INCREMENT ";
        }
        return result;
    }

    private String getUpdateFieldDesc(ColumnMeta cgfromcolumnMeta, ColumnMeta datacolumnMeta) {
        String result = this.getFieldDesc(cgfromcolumnMeta, datacolumnMeta);
        return result;
    }

    private String getAddFieldDesc(ColumnMeta cgfromcolumnMeta) {
        String result = this.getFieldDesc(cgfromcolumnMeta, null);
        return result;
    }

    private String getRenameFieldDesc(ColumnMeta cgfromcolumnMeta) {
        String result = this.getFieldDesc(cgfromcolumnMeta, null);
        return result;
    }

    @Override
    public String getCommentSql(ColumnMeta columnMeta) {
        return "";
    }

    @Override
    public String getSpecialHandle(ColumnMeta cgformcolumnMeta, ColumnMeta datacolumnMeta) {
        return null;
    }

    @Override
    public String dropIndexs(String indexName, String tableName) {
        return "DROP INDEX " + indexName + " ON " + tableName;
    }

    @Override
    public String countIndex(String indexName, String tableName) {
        return "select COUNT(*) from information_schema.statistics where table_name = '" + tableName + "'  AND index_name = '" + indexName + "'";
    }
}

