/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl;

import com.pangu.form.api.FormDefinition;
import com.pangu.form.api.FormDefinitionQuery;
import com.pangu.form.api.FormDeployment;
import com.pangu.form.api.FormDeploymentBuilder;
import com.pangu.form.api.FormDeploymentQuery;
import com.pangu.form.api.FormInfo;
import com.pangu.form.api.FormRepositoryService;
import com.pangu.form.api.NativeFormDefinitionQuery;
import com.pangu.form.api.NativeFormDeploymentQuery;
import com.pangu.form.engine.FormEngineConfiguration;
import com.pangu.form.engine.impl.FormDefinitionQueryImpl;
import com.pangu.form.engine.impl.FormDeploymentQueryImpl;
import com.pangu.form.engine.impl.NativeFormDefinitionQueryImpl;
import com.pangu.form.engine.impl.NativeFormDeploymentQueryImpl;
import com.pangu.form.engine.impl.cmd.BatchUpdateDeploymentResourceCmd;
import com.pangu.form.engine.impl.cmd.DeleteDeploymentCmd;
import com.pangu.form.engine.impl.cmd.DeployCmd;
import com.pangu.form.engine.impl.cmd.GetDeploymentResourceCmd;
import com.pangu.form.engine.impl.cmd.GetDeploymentResourceIdCmd;
import com.pangu.form.engine.impl.cmd.GetDeploymentResourceNamesCmd;
import com.pangu.form.engine.impl.cmd.GetFormDefinitionCmd;
import com.pangu.form.engine.impl.cmd.GetFormDefinitionResourceCmd;
import com.pangu.form.engine.impl.cmd.GetFormModelCmd;
import com.pangu.form.engine.impl.cmd.SetDeploymentCategoryCmd;
import com.pangu.form.engine.impl.cmd.SetDeploymentParentDeploymentIdCmd;
import com.pangu.form.engine.impl.cmd.SetDeploymentTenantIdCmd;
import com.pangu.form.engine.impl.cmd.SetFormDefinitionCategoryCmd;
import com.pangu.form.engine.impl.persistence.entity.FormResourceEntity;
import com.pangu.form.engine.impl.repository.FormDeploymentBuilderImpl;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.service.CommonEngineServiceImpl;

public class FormRepositoryServiceImpl
extends CommonEngineServiceImpl<FormEngineConfiguration>
implements FormRepositoryService {
    public FormRepositoryServiceImpl(FormEngineConfiguration engineConfiguration) {
        super((AbstractEngineConfiguration)engineConfiguration);
    }

    public FormDeploymentBuilder createDeployment() {
        return (FormDeploymentBuilder)this.commandExecutor.execute((Command)new Command<FormDeploymentBuilder>(){

            public FormDeploymentBuilder execute(CommandContext commandContext) {
                return new FormDeploymentBuilderImpl();
            }
        });
    }

    public FormDeployment deploy(FormDeploymentBuilderImpl deploymentBuilder) {
        return (FormDeployment)this.commandExecutor.execute(new DeployCmd(deploymentBuilder));
    }

    public void deleteDeployment(String deploymentId) {
        this.commandExecutor.execute((Command)new DeleteDeploymentCmd(deploymentId));
    }

    public FormDefinitionQuery createFormDefinitionQuery() {
        return new FormDefinitionQueryImpl(this.commandExecutor);
    }

    public NativeFormDefinitionQuery createNativeFormDefinitionQuery() {
        return new NativeFormDefinitionQueryImpl(this.commandExecutor);
    }

    public List<String> getDeploymentResourceNames(String deploymentId) {
        return (List)this.commandExecutor.execute((Command)new GetDeploymentResourceNamesCmd(deploymentId));
    }

    public InputStream getResourceAsStream(String deploymentId, String resourceName) {
        return (InputStream)this.commandExecutor.execute((Command)new GetDeploymentResourceCmd(deploymentId, resourceName));
    }

    public void setDeploymentCategory(String deploymentId, String category) {
        this.commandExecutor.execute((Command)new SetDeploymentCategoryCmd(deploymentId, category));
    }

    public void setDeploymentTenantId(String deploymentId, String newTenantId) {
        this.commandExecutor.execute((Command)new SetDeploymentTenantIdCmd(deploymentId, newTenantId));
    }

    public void changeDeploymentParentDeploymentId(String deploymentId, String newParentDeploymentId) {
        this.commandExecutor.execute((Command)new SetDeploymentParentDeploymentIdCmd(deploymentId, newParentDeploymentId));
    }

    public FormDeploymentQuery createDeploymentQuery() {
        return new FormDeploymentQueryImpl(this.commandExecutor);
    }

    public NativeFormDeploymentQuery createNativeDeploymentQuery() {
        return new NativeFormDeploymentQueryImpl(this.commandExecutor);
    }

    public FormDefinition getFormDefinition(String formDefinitionId) {
        return (FormDefinition)this.commandExecutor.execute((Command)new GetFormDefinitionCmd(formDefinitionId));
    }

    public FormInfo getFormModelById(String formId) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelCmd(null, formId));
    }

    public FormInfo getFormModelByKey(String formDefinitionKey) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelCmd(formDefinitionKey, null));
    }

    public FormInfo getFormModelByKey(String formDefinitionKey, String tenantId, boolean fallbackToDefaultTenant) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelCmd(formDefinitionKey, null, tenantId, fallbackToDefaultTenant));
    }

    public FormInfo getFormModelByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelCmd(formDefinitionKey, null, null, parentDeploymentId, false));
    }

    public FormInfo getFormModelByKeyAndParentDeploymentId(String formDefinitionKey, String parentDeploymentId, String tenantId, boolean fallbackToDefaultTenant) {
        return (FormInfo)this.commandExecutor.execute((Command)new GetFormModelCmd(formDefinitionKey, null, tenantId, parentDeploymentId, fallbackToDefaultTenant));
    }

    public InputStream getFormDefinitionResource(String formId) {
        return (InputStream)this.commandExecutor.execute((Command)new GetFormDefinitionResourceCmd(formId));
    }

    public void setFormDefinitionCategory(String formId, String category) {
        this.commandExecutor.execute((Command)new SetFormDefinitionCategoryCmd(formId, category));
    }

    public String getDeploymentResourceById(String id) {
        FormResourceEntity formResourceEntity = (FormResourceEntity)this.commandExecutor.execute((Command)new GetDeploymentResourceIdCmd(id));
        byte[] bytes = formResourceEntity.getBytes();
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void batchUpdateDeploymentResource(List<String> deploymentIds, byte[] bytes) {
        this.commandExecutor.execute((Command)new BatchUpdateDeploymentResourceCmd(deploymentIds, bytes));
    }
}

