/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl.db;

import com.pangu.form.engine.FormEngine;
import com.pangu.form.engine.FormEngines;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang3.StringUtils;

public class DbSchemaDrop {
    public static void main(String[] args) {
        try {
            FormEngine formEngine = FormEngines.getDefaultFormEngine();
            DataSource dataSource = formEngine.getFormEngineConfiguration().getDataSource();
            JdbcConnection connection = new JdbcConnection(dataSource.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            database.setDatabaseChangeLogTableName("PANGU_" + database.getDatabaseChangeLogTableName());
            database.setDatabaseChangeLogLockTableName("PANGU_" + database.getDatabaseChangeLogLockTableName());
            if (StringUtils.isNotEmpty((CharSequence)formEngine.getFormEngineConfiguration().getDatabaseSchema())) {
                database.setDefaultSchemaName(formEngine.getFormEngineConfiguration().getDatabaseSchema());
                database.setLiquibaseSchemaName(formEngine.getFormEngineConfiguration().getDatabaseSchema());
            }
            if (StringUtils.isNotEmpty((CharSequence)formEngine.getFormEngineConfiguration().getDatabaseCatalog())) {
                database.setDefaultCatalogName(formEngine.getFormEngineConfiguration().getDatabaseCatalog());
                database.setLiquibaseCatalogName(formEngine.getFormEngineConfiguration().getDatabaseCatalog());
            }
            Liquibase liquibase = new Liquibase("com.pangu.form.db.liquibase/liquibase/flowable-form-db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.dropAll();
            liquibase.getDatabase().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

