/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl.deployer;

import com.pangu.form.engine.impl.deployer.ParsedDeployment;
import com.pangu.form.engine.impl.parser.FormDefinitionParse;
import com.pangu.form.engine.impl.parser.FormDefinitionParseFactory;
import com.pangu.form.engine.impl.persistence.entity.FormDefinitionEntity;
import com.pangu.form.engine.impl.persistence.entity.FormDeploymentEntity;
import com.pangu.form.engine.impl.persistence.entity.FormResourceEntity;
import com.pangu.form.engine.impl.util.CommandContextUtil;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParsedDeploymentBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParsedDeploymentBuilder.class);
    public static final String[] FORM_RESOURCE_SUFFIXES = new String[]{"form"};
    protected FormDeploymentEntity deployment;
    protected FormDefinitionParseFactory formDefinitionParseFactory;

    public ParsedDeploymentBuilder(FormDeploymentEntity deployment, FormDefinitionParseFactory formDefinitionParseFactory) {
        this.deployment = deployment;
        this.formDefinitionParseFactory = formDefinitionParseFactory;
    }

    public ParsedDeployment build() {
        ArrayList<FormDefinitionEntity> formDefinitions = new ArrayList<FormDefinitionEntity>();
        LinkedHashMap<FormDefinitionEntity, FormDefinitionParse> formDefinitionToParseMap = new LinkedHashMap<FormDefinitionEntity, FormDefinitionParse>();
        LinkedHashMap<FormDefinitionEntity, FormResourceEntity> formDefinitionToResourceMap = new LinkedHashMap<FormDefinitionEntity, FormResourceEntity>();
        for (FormResourceEntity resource : this.deployment.getResources().values()) {
            if (!this.isFormResource(resource.getName())) continue;
            LOGGER.debug("Processing Form definition resource {}", (Object)resource.getName());
            FormDefinitionParse parse = this.createFormParseFromResource(resource);
            for (FormDefinitionEntity formDefinition : parse.getFormDefinitions()) {
                formDefinitions.add(formDefinition);
                formDefinitionToParseMap.put(formDefinition, parse);
                formDefinitionToResourceMap.put(formDefinition, resource);
            }
        }
        return new ParsedDeployment(this.deployment, formDefinitions, formDefinitionToParseMap, formDefinitionToResourceMap);
    }

    protected FormDefinitionParse createFormParseFromResource(FormResourceEntity resource) {
        String resourceName = resource.getName();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(resource.getBytes());
        FormDefinitionParse formParse = this.formDefinitionParseFactory.createParse().sourceInputStream(inputStream).setSourceSystemId(resourceName).deployment(this.deployment).name(resourceName);
        formParse.execute(CommandContextUtil.getFormEngineConfiguration());
        return formParse;
    }

    protected boolean isFormResource(String resourceName) {
        for (String suffix : FORM_RESOURCE_SUFFIXES) {
            if (!resourceName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }
}

