/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl.persistence.entity;

import com.pangu.form.api.FormDefinition;
import com.pangu.form.api.FormDeployment;
import com.pangu.form.engine.FormEngineConfiguration;
import com.pangu.form.engine.impl.FormDeploymentQueryImpl;
import com.pangu.form.engine.impl.persistence.entity.AbstractEntityManager;
import com.pangu.form.engine.impl.persistence.entity.FormDefinitionEntity;
import com.pangu.form.engine.impl.persistence.entity.FormDeploymentEntity;
import com.pangu.form.engine.impl.persistence.entity.FormDeploymentEntityManager;
import com.pangu.form.engine.impl.persistence.entity.FormResourceEntity;
import com.pangu.form.engine.impl.persistence.entity.data.FormDeploymentDataManager;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.persistence.entity.data.DataManager;

public class FormDeploymentEntityManagerImpl
extends AbstractEntityManager<FormDeploymentEntity>
implements FormDeploymentEntityManager {
    protected FormDeploymentDataManager deploymentDataManager;

    public FormDeploymentEntityManagerImpl(FormEngineConfiguration formEngineConfiguration, FormDeploymentDataManager deploymentDataManager) {
        super(formEngineConfiguration);
        this.deploymentDataManager = deploymentDataManager;
    }

    @Override
    protected DataManager<FormDeploymentEntity> getDataManager() {
        return this.deploymentDataManager;
    }

    @Override
    public void insert(FormDeploymentEntity deployment) {
        this.insert(deployment, true);
    }

    @Override
    public void insert(FormDeploymentEntity deployment, boolean fireEvent) {
        super.insert(deployment, fireEvent);
        for (FormResourceEntity resource : deployment.getResources().values()) {
            resource.setDeploymentId(deployment.getId());
            this.getResourceEntityManager().insert(resource);
        }
    }

    @Override
    public void deleteDeployment(String deploymentId) {
        this.deleteFormDefinitionsForDeployment(deploymentId);
        this.getResourceEntityManager().deleteResourcesByDeploymentId(deploymentId);
        this.delete(this.findById(deploymentId));
    }

    protected void deleteFormDefinitionsForDeployment(String deploymentId) {
        this.getFormDefinitionEntityManager().deleteFormDefinitionsByDeploymentId(deploymentId);
    }

    protected FormDefinitionEntity findLatestFormDefinition(FormDefinition formDefinition) {
        FormDefinitionEntity latestForm = null;
        latestForm = formDefinition.getTenantId() != null && !"".equals(formDefinition.getTenantId()) ? this.getFormDefinitionEntityManager().findLatestFormDefinitionByKeyAndTenantId(formDefinition.getKey(), formDefinition.getTenantId()) : this.getFormDefinitionEntityManager().findLatestFormDefinitionByKey(formDefinition.getKey());
        return latestForm;
    }

    @Override
    public long findDeploymentCountByQueryCriteria(FormDeploymentQueryImpl deploymentQuery) {
        return this.deploymentDataManager.findDeploymentCountByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<FormDeployment> findDeploymentsByQueryCriteria(FormDeploymentQueryImpl deploymentQuery) {
        return this.deploymentDataManager.findDeploymentsByQueryCriteria(deploymentQuery);
    }

    @Override
    public List<String> getDeploymentResourceNames(String deploymentId) {
        return this.deploymentDataManager.getDeploymentResourceNames(deploymentId);
    }

    @Override
    public List<FormDeployment> findDeploymentsByNativeQuery(Map<String, Object> parameterMap) {
        return this.deploymentDataManager.findDeploymentsByNativeQuery(parameterMap);
    }

    @Override
    public long findDeploymentCountByNativeQuery(Map<String, Object> parameterMap) {
        return this.deploymentDataManager.findDeploymentCountByNativeQuery(parameterMap);
    }

    public FormDeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public void setDeploymentDataManager(FormDeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
    }
}

