/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl.cmd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pangu.form.api.FormDeployment;
import com.pangu.form.api.FormInstance;
import com.pangu.form.api.FormInstanceInfo;
import com.pangu.form.api.FormInstanceQuery;
import com.pangu.form.engine.FormEngineConfiguration;
import com.pangu.form.engine.impl.FormDeploymentQueryImpl;
import com.pangu.form.engine.impl.persistence.deploy.DeploymentManager;
import com.pangu.form.engine.impl.persistence.deploy.FormDefinitionCacheEntry;
import com.pangu.form.engine.impl.persistence.entity.FormDefinitionEntity;
import com.pangu.form.engine.impl.persistence.entity.FormDefinitionEntityManager;
import com.pangu.form.engine.impl.persistence.entity.FormInstanceEntity;
import com.pangu.form.engine.impl.util.CommandContextUtil;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractGetFormInstanceModelCmd
implements Command<FormInstanceInfo>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGetFormInstanceModelCmd.class);
    private static final long serialVersionUID = 1L;
    protected static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("d-M-yyyy");
    protected String formInstanceId;
    protected String formDefinitionKey;
    protected String parentDeploymentId;
    protected String formDefinitionId;
    protected String taskId;
    protected String processInstanceId;
    protected String scopeId;
    protected String scopeType;
    protected String tenantId;
    protected Map<String, Object> variables;
    protected boolean fallbackToDefaultTenant;

    public FormInstanceInfo execute(CommandContext commandContext) {
        if (this.formInstanceId == null && this.taskId == null && this.processInstanceId == null && this.scopeId == null) {
            throw new FlowableException("A task id or process instance id or scope id should be provided");
        }
        FormDefinitionCacheEntry formDefinitionCacheEntry = this.resolveFormDefinition(commandContext);
        FormInstance formInstance = this.resolveFormInstance(commandContext);
        return null;
    }

    protected void initializeValues(String formDefinitionKey, String parentDeploymentId, String formDefinitionId, String tenantId, String taskId, String processInstanceId, Map<String, Object> variables, boolean fallbackToDefaultTenant) {
        this.formDefinitionKey = formDefinitionKey;
        this.parentDeploymentId = parentDeploymentId;
        this.formDefinitionId = formDefinitionId;
        this.tenantId = tenantId;
        this.taskId = taskId;
        this.processInstanceId = processInstanceId;
        this.variables = variables != null ? variables : new HashMap<String, Object>();
        this.fallbackToDefaultTenant = fallbackToDefaultTenant;
    }

    protected void initializeValuesForScope(String formDefinitionKey, String parentDeploymentId, String formDefinitionId, String tenantId, String scopeId, String scopeType, Map<String, Object> variables, boolean fallbackToDefaultTenant) {
        this.formDefinitionKey = formDefinitionKey;
        this.parentDeploymentId = parentDeploymentId;
        this.formDefinitionId = formDefinitionId;
        this.tenantId = tenantId;
        this.scopeId = scopeId;
        this.scopeType = scopeType;
        this.variables = variables != null ? variables : new HashMap<String, Object>();
        this.fallbackToDefaultTenant = fallbackToDefaultTenant;
    }

    protected void fillFormFieldValues(FormInstance formInstance, FormInstanceInfo formInstanceModel, CommandContext commandContext) {
    }

    protected FormDefinitionCacheEntry resolveFormDefinition(CommandContext commandContext) {
        List<FormDeployment> formDeployments;
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        DeploymentManager deploymentManager = formEngineConfiguration.getDeploymentManager();
        FormDefinitionEntityManager formDefinitionEntityManager = formEngineConfiguration.getFormDefinitionEntityManager();
        FormDefinitionEntity formDefinitionEntity = null;
        if (this.formInstanceId != null) {
            FormInstanceEntity formInstanceEntity = (FormInstanceEntity)CommandContextUtil.getFormEngineConfiguration().getFormInstanceDataManager().findById(this.formInstanceId);
            if (formInstanceEntity == null) {
                throw new FlowableObjectNotFoundException("No form instance found for id = '" + this.formInstanceId + "'", FormInstanceEntity.class);
            }
            formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(formInstanceEntity.getFormDefinitionId());
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for id = '" + this.formDefinitionId + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionId != null) {
            formDefinitionEntity = deploymentManager.findDeployedFormDefinitionById(this.formDefinitionId);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for id = '" + this.formDefinitionId + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && (this.parentDeploymentId == null || formEngineConfiguration.isAlwaysLookupLatestDefinitionVersion())) {
            formDefinitionEntity = deploymentManager.findDeployedLatestFormDefinitionByKey(this.formDefinitionKey);
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "'", FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && (this.parentDeploymentId == null || formEngineConfiguration.isAlwaysLookupLatestDefinitionVersion())) {
            formDefinitionEntity = formDefinitionEntityManager.findLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, this.tenantId);
            if (formDefinitionEntity == null && (this.fallbackToDefaultTenant || formEngineConfiguration.isFallbackToDefaultTenant())) {
                String defaultTenant = formEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(this.tenantId, "form", this.formDefinitionKey);
                formDefinitionEntity = StringUtils.isNotEmpty((CharSequence)defaultTenant) ? formDefinitionEntityManager.findLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, defaultTenant) : formDefinitionEntityManager.findLatestFormDefinitionByKey(this.formDefinitionKey);
            }
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && (this.tenantId == null || "".equals(this.tenantId)) && this.parentDeploymentId != null) {
            formDeployments = deploymentManager.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new FormDeploymentQueryImpl().parentDeploymentId(this.parentDeploymentId));
            if (formDeployments != null && formDeployments.size() > 0) {
                formDefinitionEntity = formDefinitionEntityManager.findFormDefinitionByDeploymentAndKey(formDeployments.get(0).getId(), this.formDefinitionKey);
            }
            if (formDefinitionEntity == null) {
                formDefinitionEntity = formDefinitionEntityManager.findLatestFormDefinitionByKey(this.formDefinitionKey);
            }
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for parent deployment id " + this.parentDeploymentId, FormDefinitionEntity.class);
            }
        } else if (this.formDefinitionKey != null && this.tenantId != null && !"".equals(this.tenantId) && this.parentDeploymentId != null) {
            formDeployments = deploymentManager.getDeploymentEntityManager().findDeploymentsByQueryCriteria(new FormDeploymentQueryImpl().parentDeploymentId(this.parentDeploymentId).deploymentTenantId(this.tenantId));
            if (formDeployments != null && formDeployments.size() > 0) {
                formDefinitionEntity = formDefinitionEntityManager.findFormDefinitionByDeploymentAndKeyAndTenantId(formDeployments.get(0).getId(), this.formDefinitionKey, this.tenantId);
            }
            if (formDefinitionEntity == null) {
                formDefinitionEntity = formDefinitionEntityManager.findLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, this.tenantId);
            }
            if (formDefinitionEntity == null && (this.fallbackToDefaultTenant || formEngineConfiguration.isFallbackToDefaultTenant())) {
                String defaultTenant = formEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(this.tenantId, "form", this.formDefinitionKey);
                formDefinitionEntity = StringUtils.isNotEmpty((CharSequence)defaultTenant) ? formDefinitionEntityManager.findLatestFormDefinitionByKeyAndTenantId(this.formDefinitionKey, defaultTenant) : formDefinitionEntityManager.findLatestFormDefinitionByKey(this.formDefinitionKey);
            }
            if (formDefinitionEntity == null) {
                throw new FlowableObjectNotFoundException("No form definition found for key '" + this.formDefinitionKey + "' for parent deployment id '" + this.parentDeploymentId + "' and for tenant identifier " + this.tenantId, FormDefinitionEntity.class);
            }
        } else {
            throw new FlowableObjectNotFoundException("formDefinitionKey and formDefinitionId are null");
        }
        FormDefinitionCacheEntry formCacheEntry = deploymentManager.resolveFormDefinition(formDefinitionEntity);
        return formCacheEntry;
    }

    protected FormInstance resolveFormInstance(CommandContext commandContext) {
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        FormInstanceQuery formInstanceQuery = formEngineConfiguration.getFormService().createFormInstanceQuery().formDefinitionId(this.formDefinitionId);
        if (this.formInstanceId != null) {
            formInstanceQuery.id(this.formInstanceId);
        } else if (this.taskId != null) {
            formInstanceQuery.taskId(this.taskId);
        } else if (this.processInstanceId != null) {
            formInstanceQuery.processInstanceId(this.processInstanceId);
            if (this.taskId == null) {
                formInstanceQuery.withoutTaskId();
            }
        } else if (this.scopeId != null) {
            formInstanceQuery.scopeId(this.scopeId);
            formInstanceQuery.scopeType(this.scopeType);
            if (this.taskId == null) {
                formInstanceQuery.withoutTaskId();
            }
        } else {
            return null;
        }
        List formInstances = ((FormInstanceQuery)formInstanceQuery.orderBySubmittedDate().asc()).list();
        if (!formInstances.isEmpty()) {
            return (FormInstance)formInstances.get(0);
        }
        return null;
    }

    protected void fillFormInstanceValues(FormInstanceInfo formInstanceModel, FormInstance formInstance, Map<String, JsonNode> formInstanceFieldMap, ObjectMapper objectMapper) {
        try {
            JsonNode outcomeNode;
            JsonNode submittedNode = objectMapper.readTree(formInstance.getFormValueBytes());
            if (submittedNode == null) {
                return;
            }
            if (submittedNode.get("values") != null) {
                JsonNode valuesNode = submittedNode.get("values");
                Iterator fieldIdIterator = valuesNode.fieldNames();
                while (fieldIdIterator.hasNext()) {
                    String fieldId = (String)fieldIdIterator.next();
                    JsonNode valueNode = valuesNode.get(fieldId);
                    formInstanceFieldMap.put(fieldId, valueNode);
                }
            }
            if (submittedNode.get("flowable_form_outcome") != null && !(outcomeNode = submittedNode.get("flowable_form_outcome")).isNull() && StringUtils.isNotEmpty((CharSequence)outcomeNode.asText())) {
                formInstanceModel.setSelectedOutcome(outcomeNode.asText());
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error parsing form instance " + formInstance.getId(), (Throwable)e);
        }
    }
}

