/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl.cmd;

import com.pangu.form.api.FormInstance;
import com.pangu.form.engine.impl.FormInstanceQueryImpl;
import com.pangu.form.engine.impl.persistence.entity.FormInstanceEntityManager;
import com.pangu.form.engine.impl.persistence.entity.FormResourceEntityManager;
import com.pangu.form.engine.impl.util.CommandContextUtil;
import java.io.Serializable;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class DeleteFormInstancesByProcessDefinitionCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processDefinitionId;

    public DeleteFormInstancesByProcessDefinitionCmd(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.processDefinitionId == null) {
            throw new FlowableIllegalArgumentException("processDefinitionId is null");
        }
        FormInstanceEntityManager formInstanceEntityManager = CommandContextUtil.getFormInstanceEntityManager(commandContext);
        FormResourceEntityManager resourceEntityManager = CommandContextUtil.getResourceEntityManager(commandContext);
        FormInstanceQueryImpl formInstanceQuery = new FormInstanceQueryImpl(commandContext);
        formInstanceQuery.processDefinitionId(this.processDefinitionId);
        List<FormInstance> formInstances = formInstanceEntityManager.findFormInstancesByQueryCriteria(formInstanceQuery);
        for (FormInstance formInstance : formInstances) {
            if (formInstance.getFormValuesId() == null) continue;
            resourceEntityManager.delete(formInstance.getFormValuesId());
        }
        formInstanceEntityManager.deleteFormInstancesByProcessDefinitionId(this.processDefinitionId);
        return null;
    }
}

