/*
 * Decompiled with CFR 0.152.
 */
package com.pangu.form.engine.impl.cmd;

import com.pangu.form.engine.impl.persistence.entity.FormDeploymentEntity;
import com.pangu.form.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class SetDeploymentCategoryCmd
implements Command<Void> {
    protected String deploymentId;
    protected String category;

    public SetDeploymentCategoryCmd(String deploymentId, String category) {
        this.deploymentId = deploymentId;
        this.category = category;
    }

    public Void execute(CommandContext commandContext) {
        if (this.deploymentId == null) {
            throw new FlowableIllegalArgumentException("Deployment id is null");
        }
        FormDeploymentEntity deployment = (FormDeploymentEntity)CommandContextUtil.getDeploymentEntityManager(commandContext).findById(this.deploymentId);
        if (deployment == null) {
            throw new FlowableObjectNotFoundException("No deployment found for id = '" + this.deploymentId + "'");
        }
        deployment.setCategory(this.category);
        CommandContextUtil.getDeploymentEntityManager(commandContext).update(deployment);
        return null;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

