/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.modules.form.constant;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.pangubpm.modules.form.exception.BusinessException;
import java.util.Arrays;

public enum PanGuColumnType {
    CLOB("clob", "\u5927\u6587\u672c\u4f7f\u7528", new String[]{"longtext", "clob"}, "String"),
    TINYINT("tinyint", "tinyint", new String[]{"tinyint"}, "tinyint"),
    BIGINT("bigint", "bigint", new String[]{"bigint"}, "bigint"),
    DOUBLE("double", "double", new String[]{"double"}, "double"),
    BIGDECIMAL("BigDecimal", "bigdecimal", new String[]{"BigDecimal"}, "bigdecimal"),
    JSON("json", "json", new String[]{"json"}, "json"),
    INT("int", "int", new String[]{"int"}, "int"),
    NUMBER("number", "\u6570\u5b57\u578b", new String[]{"integer", "number"}, "int"),
    VARCHAR("varchar", "\u5b57\u7b26\u4e32", new String[]{"varchar"}, "String"),
    DATE("date", "\u65e5\u671f\u578b", new String[]{"date", "time", "year", "datetime", "timestamp"}, "date");

    private String key;
    private String desc;
    private String[] supports;
    private String javaType;

    public static JSONArray toJson() {
        JSONArray jsonArray = new JSONArray();
        for (PanGuColumnType e : PanGuColumnType.values()) {
            JSONObject object = new JSONObject();
            object.put("key", (Object)e.getKey());
            object.put("desc", (Object)e.getDesc());
            object.put("supports", (Object)e.getSupports());
            jsonArray.add((Object)object);
        }
        return jsonArray;
    }

    private PanGuColumnType(String key, String desc, String[] supports, String javaType) {
        this.key = key;
        this.desc = desc;
        this.supports = supports;
        this.javaType = javaType;
    }

    public String getKey() {
        return this.key;
    }

    public String getDesc() {
        return this.desc;
    }

    public String[] getSupports() {
        return this.supports;
    }

    public boolean equalsWithKey(String key) {
        return this.key.equals(key);
    }

    public static PanGuColumnType getByKey(String key) {
        for (PanGuColumnType type : PanGuColumnType.values()) {
            if (!type.getKey().equals(key)) continue;
            return type;
        }
        return null;
    }

    public static PanGuColumnType getByDbDataType(String dbDataType, String errMsgApp) {
        for (PanGuColumnType type : PanGuColumnType.values()) {
            for (String support : Arrays.asList(type.supports)) {
                if (!dbDataType.toLowerCase().contains(support.toLowerCase())) continue;
                return type;
            }
        }
        throw new BusinessException(errMsgApp);
    }

    public static PanGuColumnType getByDbDataType(String dbDataType) {
        return PanGuColumnType.getByDbDataType(dbDataType, "");
    }

    public String getJavaType() {
        return this.javaType;
    }

    public void setJavaType(String javaType) {
        this.javaType = javaType;
    }
}

