/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.editor.form;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pangubpm.editor.form.PanguFormJsonException;
import com.pangubpm.editor.form.SimpleFormModelUtils;
import com.pangubpm.form.model.FormField;
import com.pangubpm.form.model.FormFieldOptions;
import com.pangubpm.form.model.SimpleFormModel;
import com.pangubpm.form.model.original.FormOriginalModel;
import com.pangubpm.form.model.original.SimpleOriginalFormModel;
import com.pangubpm.form.model.original.field.BaseGridFormColumns;
import com.pangubpm.form.model.original.field.BaseGridFormField;
import com.pangubpm.form.model.original.field.BaseOriginalFormField;
import com.pangubpm.form.model.original.options.BaseFieldOptions;
import com.pangubpm.form.model.original.options.BlockFieldOptions;
import com.pangubpm.form.model.original.options.CardFieldOptions;
import com.pangubpm.form.model.original.options.CollapseFieldOptions;
import com.pangubpm.form.model.original.options.GridFieldOptions;
import com.pangubpm.form.model.original.options.TabFieldOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class FormJsonConverter {
    protected ObjectMapper objectMapper = new ObjectMapper();

    public FormOriginalModel convertToFormModel(String modelJson, boolean disabledAll) {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleOriginalFormModel simpleOriginalFormModel = new SimpleOriginalFormModel();
        try {
            SimpleFormModel definition = (SimpleFormModel)this.objectMapper.readValue(modelJson, SimpleFormModel.class);
            List list = definition.getList();
            ArrayList<Object> result = new ArrayList<Object>(list.size());
            for (FormField formField : list) {
                Object baseFieldOptions;
                BaseOriginalFormField baseFormField;
                String name;
                String model;
                String key;
                String controlType;
                String icon;
                String type = formField.getType();
                if (type.equals("block") || type.equals("table") || type.equals("card")) {
                    icon = formField.getIcon();
                    controlType = formField.getControlType();
                    key = formField.getKey();
                    model = formField.getModel();
                    name = formField.getName();
                    baseFormField = new BaseOriginalFormField();
                    baseFormField.setKey(key);
                    baseFormField.setIcon(icon);
                    baseFormField.setModel(model);
                    baseFormField.setName(name);
                    baseFormField.setType(type);
                    baseFormField.setControlType(controlType);
                    baseFieldOptions = null;
                    baseFieldOptions = type.equals(type.equals("card")) ? new CardFieldOptions() : new BlockFieldOptions();
                    baseFormField.setOptions((BaseFieldOptions)baseFieldOptions);
                    List rules = formField.getRules();
                    baseFormField.setRules(rules);
                    List<BaseOriginalFormField> tableColumns = formField.getTableColumns();
                    tableColumns = SimpleFormModelUtils.FiledToEdit(tableColumns, disabledAll);
                    baseFormField.setTableColumns(tableColumns);
                    result.add(baseFormField);
                    continue;
                }
                if (type.equals("grid")) {
                    icon = formField.getIcon();
                    String key2 = formField.getKey();
                    String model2 = formField.getModel();
                    String name2 = formField.getName();
                    BaseGridFormField baseFormField2 = new BaseGridFormField();
                    baseFormField2.setKey(key2);
                    baseFormField2.setIcon(icon);
                    baseFormField2.setModel(model2);
                    baseFormField2.setName(name2);
                    baseFormField2.setType(type);
                    GridFieldOptions gridOptions = new GridFieldOptions();
                    baseFormField2.setOptions((BaseFieldOptions)gridOptions);
                    List columns = formField.getColumns();
                    this.fillGrid(columns);
                    baseFormField2.setColumns(columns);
                    result.add(baseFormField2);
                    continue;
                }
                if (type.equals("tabs") || type.equals("collapse")) {
                    icon = formField.getIcon();
                    controlType = formField.getControlType();
                    key = formField.getKey();
                    model = formField.getModel();
                    name = formField.getName();
                    baseFormField = new BaseOriginalFormField();
                    baseFormField.setKey(key);
                    baseFormField.setIcon(icon);
                    baseFormField.setModel(model);
                    baseFormField.setName(name);
                    baseFormField.setType(type);
                    baseFormField.setControlType(controlType);
                    if (type.equals("tabs")) {
                        baseFieldOptions = new TabFieldOptions();
                        baseFieldOptions.setActiveName(formField.getOptions().getActiveName());
                        baseFieldOptions.setOptions(formField.getOptions().getOptions());
                        baseFormField.setOptions((BaseFieldOptions)baseFieldOptions);
                    } else if (type.equals("collapse")) {
                        CollapseFieldOptions collapseFieldOptions = new CollapseFieldOptions();
                        collapseFieldOptions.setOptions(formField.getOptions().getOptions());
                        collapseFieldOptions.setAccordion(formField.getOptions().isAccordion());
                        baseFormField.setOptions((BaseFieldOptions)collapseFieldOptions);
                    }
                    List rules = formField.getRules();
                    baseFormField.setRules(rules);
                    Object[] tableColumns = formField.getTabColumns();
                    Object[] tableColumns2 = new Object[tableColumns.length];
                    for (int i = 0; i < tableColumns.length; ++i) {
                        Object tableColumn = tableColumns[i];
                        ArrayList<BaseOriginalFormField> baseOriginalFormFieldsList = new ArrayList<BaseOriginalFormField>();
                        if (tableColumn == null) continue;
                        if (tableColumn instanceof List) {
                            List tableColumnList = (List)tableColumn;
                            for (Object m : tableColumnList) {
                                String mapJson = this.objectMapper.writeValueAsString(m);
                                BaseOriginalFormField baseOriginalFormFields = (BaseOriginalFormField)this.objectMapper.readValue(mapJson, BaseOriginalFormField.class);
                                BaseOriginalFormField newBaseOriginalFormField = SimpleFormModelUtils.FiledToEditSingle(baseOriginalFormFields);
                                baseOriginalFormFieldsList.add(newBaseOriginalFormField);
                            }
                        }
                        tableColumns2[i] = baseOriginalFormFieldsList;
                    }
                    baseFormField.setTabColumns(tableColumns2);
                    result.add(baseFormField);
                    continue;
                }
                List<BaseOriginalFormField> baseFormFields = SimpleFormModelUtils.converSimpleFiledToEdit(Arrays.asList(formField), disabledAll);
                result.add(baseFormFields.get(0));
            }
            simpleOriginalFormModel.setList(result);
            simpleOriginalFormModel.setConfig(definition.getConfig());
            return simpleOriginalFormModel;
        }
        catch (Exception e) {
            throw new PanguFormJsonException("Error reading form json", e);
        }
    }

    private void fillGrid(List<BaseGridFormColumns> columns) {
        for (int i = 0; i < columns.size(); ++i) {
            List bgfc = columns.get(i).getList();
            for (int j = 0; j < bgfc.size(); ++j) {
                BaseGridFormField baseGridFormField = (BaseGridFormField)bgfc.get(j);
                BaseFieldOptions baseFieldOptions = SimpleFormModelUtils.getBaseFieldOptions(baseGridFormField.getType());
                if (baseGridFormField.getColumns() == null) {
                    baseGridFormField.setOptions(baseFieldOptions);
                    continue;
                }
                baseGridFormField.setOptions(baseFieldOptions);
                this.fillGrid(baseGridFormField.getColumns());
            }
        }
    }

    private BaseFieldOptions converOriginal(FormFieldOptions options) {
        GridFieldOptions gridFieldOptions = new GridFieldOptions();
        gridFieldOptions.setAlign(options.getAlign());
        gridFieldOptions.setCustomClass(options.getCustomClass());
        gridFieldOptions.setGutter(options.getGutter());
        gridFieldOptions.setJustify(options.getJustify());
        gridFieldOptions.setRemoteFunc(options.getRemoteFunc());
        return gridFieldOptions;
    }

    public String convertToJson(FormOriginalModel definition) {
        try {
            return this.objectMapper.writeValueAsString((Object)definition);
        }
        catch (Exception e) {
            throw new PanguFormJsonException("Error writing form json", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readJsonToString(String resource) {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(resource);){
            String string = IOUtils.toString((InputStream)is, (String)"utf-8");
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected JsonNode parseJson(String resource) {
        String jsonString = this.readJsonToString(resource);
        try {
            return this.objectMapper.readTree(jsonString);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

