/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.editor.form;

import com.pangubpm.form.model.FormConfig;
import com.pangubpm.form.model.FormField;
import com.pangubpm.form.model.FormFieldOptions;
import com.pangubpm.form.model.GridOptions;
import com.pangubpm.form.model.SimpleFormModel;
import com.pangubpm.form.model.original.FormOriginalModel;
import com.pangubpm.form.model.original.SimpleOriginalFormModel;
import com.pangubpm.form.model.original.field.BaseOriginalFormField;
import com.pangubpm.form.model.original.options.BaseFieldOptions;
import com.pangubpm.form.model.original.options.IframeOptions;
import com.pangubpm.form.model.original.options.SliderOptions;
import com.pangubpm.form.model.original.options.Vue2Editor;
import com.pangubpm.form.model.original.options.alert.AlertOptions;
import com.pangubpm.form.model.original.options.badge.BadgeOptions;
import com.pangubpm.form.model.original.options.breadcrumb.BreadcrumbOptions;
import com.pangubpm.form.model.original.options.btn.CheckboxBtnFieldOptions;
import com.pangubpm.form.model.original.options.btn.CommonBtn;
import com.pangubpm.form.model.original.options.btn.RadioBtnFieldOptions;
import com.pangubpm.form.model.original.options.btn.SelectBtnFieldOptions;
import com.pangubpm.form.model.original.options.date.DateDateFieldOptions;
import com.pangubpm.form.model.original.options.date.TimeDateFieldOptions;
import com.pangubpm.form.model.original.options.datecalendar.DateCalendarOptions;
import com.pangubpm.form.model.original.options.dialog.DialogOptions;
import com.pangubpm.form.model.original.options.dialog.UserDialogOptions;
import com.pangubpm.form.model.original.options.distpicker.DistpickerOptions;
import com.pangubpm.form.model.original.options.file.FileUploadFieldOptions;
import com.pangubpm.form.model.original.options.file.ImageUploadFieldOptions;
import com.pangubpm.form.model.original.options.inputnumber.InputNumberOptions;
import com.pangubpm.form.model.original.options.link.LinkOptions;
import com.pangubpm.form.model.original.options.progress.ProgressOptions;
import com.pangubpm.form.model.original.options.steps.StepsOptions;
import com.pangubpm.form.model.original.options.tag.TagOptions;
import com.pangubpm.form.model.original.options.text.DividerFieldOptions;
import com.pangubpm.form.model.original.options.text.InputFieldOptions;
import com.pangubpm.form.model.original.options.text.TextAreaFieldOptions;
import com.pangubpm.form.model.original.options.text.TextFieldOptions;
import com.pangubpm.form.model.original.options.uncommonlyused.IconOptions;
import com.pangubpm.form.model.original.options.uncommonlyused.UncommonlyUsedOptions;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;

public class SimpleFormModelUtils {
    public static FormOriginalModel converSimpleToEdit(SimpleFormModel simpleFormModel) {
        SimpleOriginalFormModel formOriginalModel = new SimpleOriginalFormModel();
        FormConfig config = simpleFormModel.getConfig();
        formOriginalModel.setConfig(config);
        List list = simpleFormModel.getList();
        return formOriginalModel;
    }

    public static List<BaseOriginalFormField> converSimpleFiledToEdit(List<FormField> list, boolean disabledAll) {
        ArrayList<BaseOriginalFormField> result = new ArrayList<BaseOriginalFormField>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            FormField formField = list.get(i);
            String icon = formField.getIcon();
            String type = formField.getType();
            String controlType = formField.getControlType();
            String key = formField.getKey();
            String model = formField.getModel();
            String name = formField.getName();
            BaseOriginalFormField baseFormField = new BaseOriginalFormField();
            baseFormField.setKey(key);
            baseFormField.setIcon(icon);
            baseFormField.setModel(model);
            baseFormField.setName(name);
            baseFormField.setType(type);
            baseFormField.setControlType(controlType);
            FormFieldOptions options = formField.getOptions();
            List rules = formField.getRules();
            baseFormField.setRules(rules);
            BaseFieldOptions baseFieldOptions = SimpleFormModelUtils.getBaseFieldOptions(type);
            try {
                BeanUtils.copyProperties((Object)baseFieldOptions, (Object)options);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            baseFieldOptions.setDisabled(disabledAll);
            baseFormField.setOptions(baseFieldOptions);
            result.add(baseFormField);
        }
        return result;
    }

    public static List<BaseOriginalFormField> FiledToEdit(List<BaseOriginalFormField> tableColumns, boolean disabledAll) {
        ArrayList<BaseOriginalFormField> result = new ArrayList<BaseOriginalFormField>(tableColumns.size());
        for (int i = 0; i < tableColumns.size(); ++i) {
            BaseOriginalFormField baseOriginalFormField = tableColumns.get(i);
            BaseFieldOptions baseFieldOptions = SimpleFormModelUtils.getBaseFieldOptions(baseOriginalFormField);
            baseOriginalFormField.setOptions(baseFieldOptions);
            baseFieldOptions.setDisabled(disabledAll);
            result.add(baseOriginalFormField);
        }
        return result;
    }

    public static BaseOriginalFormField FiledToEditSingle(BaseOriginalFormField baseOriginalFormField) {
        BaseFieldOptions baseFieldOptions = SimpleFormModelUtils.getBaseFieldOptions(baseOriginalFormField);
        baseOriginalFormField.setOptions(baseFieldOptions);
        baseFieldOptions.setDisabled(false);
        return baseOriginalFormField;
    }

    public static BaseFieldOptions getBaseFieldOptions(BaseOriginalFormField baseOriginalFormField) {
        String type = baseOriginalFormField.getType();
        return SimpleFormModelUtils.getBaseFieldOptions(type);
    }

    public static BaseFieldOptions getBaseFieldOptions(String type) {
        Object baseFieldOptions = null;
        if (type.equals("input")) {
            baseFieldOptions = new InputFieldOptions();
        } else if (type.equals("textarea")) {
            baseFieldOptions = new TextAreaFieldOptions();
        } else if (type.equals("vue2Editor")) {
            baseFieldOptions = new Vue2Editor();
        } else if (type.equals("select")) {
            baseFieldOptions = new SelectBtnFieldOptions();
        } else if (type.equals("radio")) {
            baseFieldOptions = new RadioBtnFieldOptions();
        } else if (type.equals("checkbox")) {
            baseFieldOptions = new CheckboxBtnFieldOptions();
        } else if (type.equals("date")) {
            baseFieldOptions = new DateDateFieldOptions();
        } else if (type.equals("time")) {
            baseFieldOptions = new TimeDateFieldOptions();
        } else if (type.equals("iframe")) {
            baseFieldOptions = new IframeOptions();
        } else if (type.equals("text")) {
            baseFieldOptions = new TextFieldOptions();
        } else if (type.equals("divider")) {
            baseFieldOptions = new DividerFieldOptions();
        } else if (type.equals("number")) {
            baseFieldOptions = new InputFieldOptions();
        } else if (type.equals("dialog")) {
            baseFieldOptions = new DialogOptions();
        } else if (type.equals("userDialog")) {
            baseFieldOptions = new UserDialogOptions();
        } else if (type.equals("tag")) {
            baseFieldOptions = new TagOptions();
        } else if (type.equals("link")) {
            baseFieldOptions = new LinkOptions();
        } else if (type.equals("badge")) {
            baseFieldOptions = new BadgeOptions();
        } else if (type.equals("inputNumber")) {
            baseFieldOptions = new InputNumberOptions();
        } else if (type.equals("progress")) {
            baseFieldOptions = new ProgressOptions();
        } else if (type.equals("dateCalendar")) {
            baseFieldOptions = new DateCalendarOptions();
        } else if (type.equals("steps")) {
            baseFieldOptions = new StepsOptions();
        } else if (type.equals("breadcrumb")) {
            baseFieldOptions = new BreadcrumbOptions();
        } else if (type.equals("icon")) {
            baseFieldOptions = new IconOptions();
        } else if (type.equals("btn")) {
            baseFieldOptions = new CommonBtn();
        } else if (type.equals("alert")) {
            baseFieldOptions = new AlertOptions();
        } else if (type.equals("h4") || type.equals("p") || type.equals("small") || type.equals("mark") || type.equals("del") || type.equals("u") || type.equals("dividers") || type.equals("em") || type.equals("strong")) {
            baseFieldOptions = new UncommonlyUsedOptions();
        } else if (type.equals("grid")) {
            baseFieldOptions = new GridOptions();
            baseFieldOptions.setShowTitle(false);
        } else {
            baseFieldOptions = type.equals("distpicker") ? new DistpickerOptions() : (type.equals("fileUpload") ? new FileUploadFieldOptions() : (type.equals("imgupload") ? new ImageUploadFieldOptions() : (type.equals("slider") ? new SliderOptions() : new BaseFieldOptions())));
        }
        return baseFieldOptions;
    }
}

