/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils.httpclient;

import com.pangubpm.common.utils.httpclient.ResponseDTO;
import com.pangubpm.common.utils.httpclient.ReturnCode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionManager {
    private static Logger LOG = LoggerFactory.getLogger(HttpConnectionManager.class);
    private static final int MAX_TOTAL_CONNECTIONS = 200;
    private static final int MAX_WAIT_TIMEOUT = 6000;
    public static final int MAX_ROUTE_CONNTCIONS = 100;
    public static final int CONNECT_TIMEOUT = 6000;
    private static final String CHARSET = "UTF-8";
    private static final String CONTENT_TYPE = "application/json";
    public static final int READ_TIMEOUT = 10000;

    public static ResponseDTO doGet(String url) {
        return HttpConnectionManager.doGet(url, CHARSET);
    }

    public static ResponseDTO doGet(String url, String userName, String password) {
        return HttpConnectionManager.doGet(url, userName, password, CHARSET);
    }

    public static ResponseDTO doGet(String url, String charset) {
        return HttpConnectionManager.doGet(url, null, null, charset);
    }

    public static ResponseDTO doGet(String url, String userName, String password, String charset) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalAccessError("\u5165\u53c2url \u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = CHARSET;
        }
        HttpGet request = new HttpGet(url);
        if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password)) {
            byte[] credentials = Base64.encodeBase64((byte[])(userName + ":" + password).getBytes(StandardCharsets.UTF_8));
            request.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
        }
        return HttpConnectionManager.send(request, charset);
    }

    public static <K, V> ResponseDTO doGet(String url, Map<K, V> params) {
        return HttpConnectionManager.doGet(url, params, CHARSET);
    }

    public static <K, V> ResponseDTO doGet(String url, Map<K, V> params, String charset) {
        return HttpConnectionManager.doGet(url, null, null, params, charset);
    }

    public static <K, V> ResponseDTO doGet(String url, String userName, String password, Map<K, V> params, String charset) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("url \u4e3a\u7a7a");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(url);
        try {
            List<NameValuePair> pairsList = HttpConnectionManager.getParamsList(params);
            if (pairsList.size() > 0) {
                buffer.append("?");
                buffer.append(EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairsList, charset)));
            }
            HttpGet request = new HttpGet(buffer.toString());
            if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password)) {
                byte[] credentials = Base64.encodeBase64((byte[])(userName + ":" + password).getBytes(StandardCharsets.UTF_8));
                request.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
            }
            return HttpConnectionManager.send(request, charset);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }

    public static ResponseDTO doPost(String url) {
        return HttpConnectionManager.doPost(url, CHARSET);
    }

    public static ResponseDTO doPost(String url, String charset) {
        return HttpConnectionManager.doPost(url, null, null, charset);
    }

    public static ResponseDTO doPost(String url, String userName, String password, String charset) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("\u5165\u53c2url\u4e3a\u7a7a!!");
        }
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = CHARSET;
        }
        HttpPost request = new HttpPost(url);
        if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password)) {
            byte[] credentials = Base64.encodeBase64((byte[])(userName + ":" + password).getBytes(StandardCharsets.UTF_8));
            request.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
        }
        return HttpConnectionManager.send(request, charset);
    }

    public static <T> ResponseDTO post(String url, T data) {
        return HttpConnectionManager.doPost(url, data, CHARSET);
    }

    public static <T> ResponseDTO post(String url, String userName, String password, T data) {
        return HttpConnectionManager.doPost(url, userName, password, data, CHARSET);
    }

    public static <T> ResponseDTO doPost(String url, T data, String charset) {
        return HttpConnectionManager.doPost(url, null, null, data, charset);
    }

    public static <T> ResponseDTO doPost(String url, String userName, String password, T data, String charset) {
        String result;
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("\u5165\u53c2url\u4e3a\u7a7a!!");
        }
        String string = result = data == null ? "" : data.toString().trim();
        if (StringUtils.isBlank((CharSequence)result)) {
            return HttpConnectionManager.doPost(url);
        }
        try {
            HttpPost request = new HttpPost(url);
            if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password)) {
                byte[] credentials = Base64.encodeBase64((byte[])(userName + ":" + password).getBytes(StandardCharsets.UTF_8));
                request.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
            }
            StringEntity entity = new StringEntity(result, charset);
            entity.setContentEncoding(charset);
            entity.setContentType(CONTENT_TYPE);
            request.setEntity((HttpEntity)entity);
            return HttpConnectionManager.send(request, charset);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }

    public static <K, V> ResponseDTO doPost(String url, Map<K, V> params) {
        return HttpConnectionManager.doPost(url, params, CHARSET);
    }

    public static <K, V> ResponseDTO doPost(String url, Map<K, V> params, String charset) {
        return HttpConnectionManager.doPost(url, null, null, params, charset);
    }

    public static <K, V> ResponseDTO doPost(String url, String userName, String password, Map<K, V> params, String charset) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("\u5165\u53c2url\u4e3a\u7a7a!!");
        }
        if (params == null || params.size() == 0) {
            return HttpConnectionManager.doPost(url);
        }
        try {
            List<NameValuePair> pairsList = HttpConnectionManager.getParamsList(params);
            HttpPost request = new HttpPost(url);
            if (pairsList.size() > 0) {
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(pairsList, charset));
            }
            if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password)) {
                byte[] credentials = Base64.encodeBase64((byte[])(userName + ":" + password).getBytes(StandardCharsets.UTF_8));
                request.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
            }
            return HttpConnectionManager.send(request, charset);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends HttpRequestBase> ResponseDTO send(T request, String charset) {
        ResponseDTO responseDto = new ResponseDTO(ReturnCode.ERROR_RESOURCES);
        CloseableHttpResponse response = null;
        try {
            CloseableHttpClient httpClient = HttpConnectionManager.buildHttpClient();
            request.setConfig(HttpConnectionManager.buildRequestConfig());
            response = httpClient.execute(request);
            int statusCode = response.getStatusLine().getStatusCode();
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET);
            }
            responseDto.setCode(statusCode);
            responseDto.setAttach(result);
            ResponseDTO responseDTO = responseDto;
            return responseDTO;
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            ResponseDTO responseDTO = responseDto;
            return responseDTO;
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage());
                }
            }
        }
    }

    public static RequestConfig buildRequestConfig() {
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(6000).setConnectTimeout(6000).build();
        return requestConfig;
    }

    private static <K, V> List<NameValuePair> getParamsList(Map<K, V> params) {
        ArrayList<NameValuePair> pairsList = new ArrayList<NameValuePair>();
        if (params == null || params.size() == 0) {
            return pairsList;
        }
        for (Map.Entry<K, V> entry : params.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            if (key == null || value == null || StringUtils.isBlank((CharSequence)key.toString()) || StringUtils.isBlank((CharSequence)value.toString())) {
                LOG.info("\u53c2\u6570\u7684key \u6216\u8005value \u4e3a\u7a7a!!!");
                continue;
            }
            pairsList.add((NameValuePair)new BasicNameValuePair(key.toString(), value.toString()));
        }
        return pairsList;
    }

    private static CloseableHttpClient buildHttpClient() {
        PoolingHttpClientConnectionManager pcm = new PoolingHttpClientConnectionManager();
        pcm.setMaxTotal(200);
        pcm.setDefaultMaxPerRoute(100);
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)pcm).build();
    }

    public static <K, V> ResponseDTO doPut(String url, String userName, String password, Map<K, V> params, String charset) {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("\u5165\u53c2url\u4e3a\u7a7a!!");
        }
        try {
            List<NameValuePair> pairsList = HttpConnectionManager.getParamsList(params);
            HttpPut request = new HttpPut(url);
            if (pairsList.size() > 0) {
                request.setEntity((HttpEntity)new UrlEncodedFormEntity(pairsList, charset));
            }
            if (StringUtils.isNotBlank((CharSequence)userName) && StringUtils.isNotBlank((CharSequence)password)) {
                byte[] credentials = Base64.encodeBase64((byte[])(userName + ":" + password).getBytes(StandardCharsets.UTF_8));
                request.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
            }
            return HttpConnectionManager.send(request, charset);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return null;
        }
    }
}

