/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.db.operate;

import com.pangubpm.common.db.exception.DBException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbTypeOperate {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Properties databaseTypeMappings;
    public static String databaseType;
    public static DataSource dataSource;
    public static final String DB_TYPE_MYSQL = "MYSQL";
    public static final String DB_TYPE_ORACLE = "ORACLE";
    public static final String DB_TYPE_POSTGRESQL = "POSTGRESQL";
    public static final String DB_TYPE_SQLSERVER = "SQLSERVER";
    public static final String PRODUCT_NAME_POSTGRES = "PostgreSQL";
    public static final String PRODUCT_NAME_CRDB = "CockroachDB";
    public static final String DATABASE_TYPE_H2 = "h2";
    public static final String DATABASE_TYPE_HSQL = "hsql";
    public static String DATABASE_TYPE_MYSQL;
    public static final String DATABASE_TYPE_ORACLE = "oracle";
    public static final String DATABASE_TYPE_POSTGRES = "postgres";
    public static final String PRODUCT_NAME_DM = "DM DBMS";
    public static final String DATABASE_TYPE_MSSQL = "mssql";
    public static final String DATABASE_TYPE_DB2 = "db2";
    public static final String DATABASE_TYPE_COCKROACHDB = "cockroachdb";

    public void setDatabaseTypeMappings(Properties databaseTypeMappings) {
        this.databaseTypeMappings = databaseTypeMappings;
    }

    public void setDatabaseType(String databaseType) {
    }

    public static DataSource getDataSource() {
        return dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        DbTypeOperate.dataSource = dataSource;
    }

    public DbTypeOperate(DataSource dataSource) {
        DbTypeOperate.dataSource = dataSource;
        this.databaseTypeMappings = DbTypeOperate.getDefaultDatabaseTypeMappings();
        this.initDatabaseType(dataSource);
    }

    public static Properties getDefaultDatabaseTypeMappings() {
        Properties databaseTypeMappings = new Properties();
        databaseTypeMappings.setProperty("H2", DATABASE_TYPE_H2);
        databaseTypeMappings.setProperty("HSQL Database Engine", DATABASE_TYPE_HSQL);
        databaseTypeMappings.setProperty("MySQL", DATABASE_TYPE_MYSQL);
        databaseTypeMappings.setProperty("MariaDB", DATABASE_TYPE_MYSQL);
        databaseTypeMappings.setProperty("Oracle", DATABASE_TYPE_ORACLE);
        databaseTypeMappings.setProperty(PRODUCT_NAME_POSTGRES, DATABASE_TYPE_POSTGRES);
        databaseTypeMappings.setProperty("Microsoft SQL Server", DATABASE_TYPE_MSSQL);
        databaseTypeMappings.setProperty(DATABASE_TYPE_DB2, DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/NT", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/NT64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDP", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUX390", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXX8664", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXZ64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/LINUXPPC64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/400 SQL", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/6000", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDB iSeries", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/AIX64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/HPUX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/HP64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/SUN", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/SUN64", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/PTX", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2/2", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty("DB2 UDB AS400", DATABASE_TYPE_DB2);
        databaseTypeMappings.setProperty(PRODUCT_NAME_CRDB, DATABASE_TYPE_COCKROACHDB);
        return databaseTypeMappings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initDatabaseType(DataSource dataSource) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String databaseProductName = databaseMetaData.getDatabaseProductName();
            this.logger.debug("database product name: '{}'", (Object)databaseProductName);
            if (PRODUCT_NAME_POSTGRES.equalsIgnoreCase(databaseProductName)) {
                preparedStatement = connection.prepareStatement("select version() as version;");
                resultSet = preparedStatement.executeQuery();
                String version = null;
                if (resultSet.next()) {
                    version = resultSet.getString("version");
                }
                resultSet.close();
                if (StringUtils.isNotEmpty((CharSequence)version) && version.toLowerCase().startsWith(PRODUCT_NAME_CRDB.toLowerCase())) {
                    databaseProductName = PRODUCT_NAME_CRDB;
                    this.logger.info("CockroachDB version '{}' detected", (Object)version);
                }
            }
            if ((databaseType = this.databaseTypeMappings.getProperty(databaseProductName)) == null) {
                throw new FlowableException("couldn't deduct database type from database product name '" + databaseProductName + "'");
            }
            this.logger.debug("using database type: {}", (Object)databaseType);
            this.close(connection, preparedStatement, resultSet);
        }
        catch (SQLException e) {
            this.logger.error("Exception while initializing Database connection", (Throwable)e);
        }
        finally {
            this.close(connection, preparedStatement, resultSet);
        }
    }

    private void close(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException throwables) {
                this.logger.info("preparedStatementSQLException", (Throwable)throwables);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException throwables) {
                this.logger.info("SQLException", (Throwable)throwables);
            }
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException throwables) {
                this.logger.info("Exception", (Throwable)throwables);
            }
        }
    }

    public static String getDatabaseType() {
        return databaseType;
    }

    public static String getTableName(String tableName, String dataBaseType) {
        switch (dataBaseType) {
            case "ORACLE": {
                return tableName.toUpperCase();
            }
            case "POSTGRESQL": {
                return tableName.toLowerCase();
            }
        }
        return tableName;
    }

    public static String getDialect() throws SQLException, DBException {
        String databaseType = DbTypeOperate.getDatabaseType();
        return DbTypeOperate.getDialect(databaseType);
    }

    public static String getDialect(String databaseType) throws SQLException, DBException {
        String dialect = "org.hibernate.dialect.MySQL5InnoDBDialect";
        switch (databaseType) {
            case "SQLSERVER": {
                dialect = "org.hibernate.dialect.SQLServerDialect";
                break;
            }
            case "POSTGRESQL": {
                dialect = "org.hibernate.dialect.PostgreSQLDialect";
                break;
            }
            case "ORACLE": {
                dialect = "org.hibernate.dialect.OracleDialect";
                break;
            }
        }
        return dialect;
    }

    public Properties getDatabaseTypeMappings() {
        return this.databaseTypeMappings;
    }

    static {
        DATABASE_TYPE_MYSQL = "mysql";
    }
}

