/*
 * Decompiled with CFR 0.152.
 */
package com.pangubpm.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;

public class TemplateUtils {
    private static Pattern PATTERN = Pattern.compile("^\\d+(,\\d+)*(\\.\\d+)*$");
    private static Pattern EXPRESS = Pattern.compile("\\$\\{([^}]+)}");
    private static String defaultCharacter = "UTF-8";

    private TemplateUtils() {
    }

    public static String processTemplate(String myTemplate, Map<String, Object> map) {
        String result = null;
        String name = "template";
        Matcher matcher = EXPRESS.matcher(myTemplate);
        while (matcher.find()) {
            Matcher rowMatcher;
            String fieldName = matcher.group(1);
            Object o = map.get(fieldName);
            if (o == null || !(rowMatcher = PATTERN.matcher(o.toString())).find()) continue;
            map.put(fieldName, o.toString().replaceAll(",", ""));
        }
        try {
            StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
            stringTemplateLoader.putTemplate(name, myTemplate);
            Configuration cfg = new Configuration(Configuration.VERSION_2_3_27);
            cfg.setDefaultEncoding(defaultCharacter);
            cfg.setTagSyntax(0);
            cfg.setNumberFormat("0.########");
            cfg.setTemplateLoader((TemplateLoader)stringTemplateLoader);
            Template template = cfg.getTemplate(name, defaultCharacter);
            StringWriter out = new StringWriter();
            template.process(map, (Writer)out);
            out.flush();
            result = out.toString();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("purchaseType", "01");
        map.put("totalAmount", 1.4722455555555444E22);
        map.put("applicant", "1001_\u6768\u5a013");
        String jsonString = JSONObject.toJSONString(map);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.readTree(jsonString);
        jsonString = mapper.writeValueAsString((Object)jsonNode);
        map = (Map)mapper.readValue(jsonString, Map.class);
        String template = "\"${purchaseType}\" == \"01\" && totalAmount >= 200000 && \"${applicant}\" != \"1001_\u6768\u5a01\" && \"${applicant}\" != \"xuhao_\u5f90\u660a\"";
        String result = TemplateUtils.processTemplate(template, map);
        System.out.println(result);
        ScriptEngine js = new ScriptEngineManager().getEngineByName("JavaScript");
        System.out.println(js.eval(result, (Bindings)new SimpleBindings(map)));
    }
}

